/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.kafka.ser;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.kafka.ser.SerializationException;

public class ResultSerializer
implements Serializer<Object> {
    private final ObjectMapper objectMapper;
    private String encoding = "UTF8";

    public ResultSerializer(OpenLService service, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        Object encodingValue = configs.get("value.serializer.encoding");
        if (encodingValue == null) {
            encodingValue = configs.get("serializer.encoding");
        }
        if (encodingValue instanceof String) {
            this.encoding = (String)encodingValue;
        }
    }

    public byte[] serialize(String topic, Object data) {
        try {
            if (data instanceof String) {
                return ((String)data).getBytes(this.encoding);
            }
            return this.objectMapper.writeValueAsString(data).getBytes(this.encoding);
        }
        catch (Exception e) {
            throw new SerializationException("Failed to write a result.", e);
        }
    }

    public void close() {
    }
}

