/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.oas.integration.ClasspathOpenApiConfigurationLoader;
import io.swagger.v3.oas.integration.FileOpenApiConfigurationLoader;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.info.Info;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.openapi.OpenApiCustomizer;
import org.apache.cxf.jaxrs.openapi.OpenApiFeature;
import org.apache.cxf.jaxrs.spring.JAXRSServerFactoryBeanDefinitionParser;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceDeployException;
import org.openl.rules.ruleservice.core.RuleServiceUndeployException;
import org.openl.rules.ruleservice.core.ServiceDescription;
import org.openl.rules.ruleservice.publish.RuleServicePublisher;
import org.openl.rules.ruleservice.publish.TextPlainMessageProvider;
import org.openl.rules.ruleservice.publish.URLHelper;
import org.openl.rules.ruleservice.publish.jaxrs.JAXRSOpenLServiceEnhancer;
import org.openl.rules.ruleservice.publish.jaxrs.swagger.OpenApiHackContainerRequestFilter;
import org.openl.rules.ruleservice.publish.jaxrs.swagger.OpenApiHackContainerResponseFilter;
import org.openl.rules.ruleservice.publish.jaxrs.swagger.OpenApiObjectMapperHack;
import org.openl.rules.ruleservice.storelogdata.CollectOperationResourceInfoInterceptor;
import org.openl.rules.ruleservice.storelogdata.CollectRequestMessageInInterceptor;
import org.openl.rules.ruleservice.storelogdata.CollectResponseMessageOutInterceptor;
import org.openl.rules.ruleservice.storelogdata.PopulateStoreLogDataInterceptor;
import org.openl.rules.ruleservice.storelogdata.StoreLogDataManager;
import org.openl.rules.serialization.JacksonObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class JAXRSRuleServicePublisher
implements RuleServicePublisher {
    public static final String REST_PREFIX = "REST/";
    private final Logger log = LoggerFactory.getLogger(JAXRSRuleServicePublisher.class);
    private final Map<OpenLService, Server> runningServices = new ConcurrentHashMap<OpenLService, Server>();
    @Value(value="${ruleservice.authentication.enabled}")
    private boolean authenticationEnabled;
    @Autowired
    @Qualifier(value="jaxrsOpenApiObjectMapper")
    private ObjectFactory<JacksonObjectMapperFactory> jaxrsOpenApiObjectMapper;
    @Autowired
    @Qualifier(value="jaxrsServiceObjectMapper")
    private ObjectFactory<JacksonObjectMapperFactory> jaxrsServiceObjectMapper;
    @Autowired
    @Qualifier(value="serviceDescriptionInProcess")
    private ObjectFactory<ServiceDescription> serviceDescriptionObjectFactory;
    @Autowired
    private StoreLogDataManager storeLogDataManager;
    @Autowired
    private List<ExceptionMapper> exceptionMappers;
    @Autowired
    private List<Feature> features;
    @Autowired
    private Environment env;

    public StoreLogDataManager getStoreLogDataManager() {
        return this.storeLogDataManager;
    }

    public void setStoreLogDataManager(StoreLogDataManager storeLogDataManager) {
        this.storeLogDataManager = storeLogDataManager;
    }

    public ObjectFactory<ServiceDescription> getServiceDescriptionObjectFactory() {
        return this.serviceDescriptionObjectFactory;
    }

    public void setServiceDescriptionObjectFactory(ObjectFactory<ServiceDescription> serviceDescriptionObjectFactory) {
        this.serviceDescriptionObjectFactory = serviceDescriptionObjectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(OpenLService service) throws RuleServiceDeployException {
        Objects.requireNonNull(service, "service cannot be null");
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        OpenApiObjectMapperHack openApiObjectMapperHack = null;
        try {
            Thread.currentThread().setContextClassLoader(service.getClassLoader());
            JAXRSServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean svrFactory = new JAXRSServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean();
            svrFactory.setApplicationContext((ApplicationContext)service.getServiceContext());
            String url = "/" + this.getUrl(service);
            svrFactory.setAddress(url);
            svrFactory.getFeatures().addAll(this.features);
            ObjectMapper serviceObjectMapper = ((JacksonObjectMapperFactory)this.jaxrsServiceObjectMapper.getObject()).createJacksonObjectMapper();
            ObjectMapper openApiObjectMapper = ((JacksonObjectMapperFactory)this.jaxrsOpenApiObjectMapper.getObject()).createJacksonObjectMapper();
            svrFactory.setProvider((Object)new TextPlainMessageProvider(serviceObjectMapper));
            svrFactory.setProvider((Object)new JacksonJsonProvider(serviceObjectMapper));
            if (this.getStoreLogDataManager().isEnabled()) {
                CollectRequestMessageInInterceptor storeLogDataInInterceptor = new CollectRequestMessageInInterceptor();
                svrFactory.getInInterceptors().add(storeLogDataInInterceptor);
                svrFactory.getInFaultInterceptors().add(storeLogDataInInterceptor);
                CollectResponseMessageOutInterceptor storeLogDataOutInterceptor = new CollectResponseMessageOutInterceptor(this.getStoreLogDataManager());
                svrFactory.getOutInterceptors().add(storeLogDataOutInterceptor);
                svrFactory.getOutFaultInterceptors().add(storeLogDataOutInterceptor);
                PopulateStoreLogDataInterceptor serviceInterceptor = new PopulateStoreLogDataInterceptor(service, serviceObjectMapper);
                svrFactory.getInInterceptors().add(serviceInterceptor);
                svrFactory.getInFaultInterceptors().add(serviceInterceptor);
                CollectOperationResourceInfoInterceptor operationResourceInfoInterceptor = new CollectOperationResourceInfoInterceptor();
                svrFactory.getInInterceptors().add(operationResourceInfoInterceptor);
                svrFactory.getInFaultInterceptors().add(operationResourceInfoInterceptor);
            }
            openApiObjectMapperHack = new OpenApiObjectMapperHack();
            openApiObjectMapperHack.apply(openApiObjectMapper);
            svrFactory.setProviders(this.exceptionMappers);
            svrFactory.setProvider((Object)new OpenApiHackContainerRequestFilter(openApiObjectMapper));
            svrFactory.setProvider((Object)new OpenApiHackContainerResponseFilter());
            Object proxyServiceBean = new JAXRSOpenLServiceEnhancer().decorateServiceBean(service);
            Class<?> serviceClass = proxyServiceBean.getClass().getInterfaces()[0];
            svrFactory.setResourceClasses(new Class[]{serviceClass});
            OpenApiFeature openApiFeature = this.getOpenAPIv3Feature(serviceClass, service);
            svrFactory.getFeatures().add(openApiFeature);
            svrFactory.setResourceProvider(serviceClass, (ResourceProvider)new SingletonResourceProvider(proxyServiceBean));
            ClassLoader origClassLoader = (ClassLoader)svrFactory.getBus().getExtension(ClassLoader.class);
            try {
                svrFactory.getBus().setExtension((Object)service.getClassLoader(), ClassLoader.class);
                Server wsServer = svrFactory.create();
                this.runningServices.put(service, wsServer);
                this.log.info("Service '{}' has been exposed with URL '{}'.", (Object)service.getDeployPath(), (Object)url);
            }
            finally {
                svrFactory.getBus().setExtension((Object)origClassLoader, ClassLoader.class);
            }
        }
        catch (Exception t) {
            throw new RuleServiceDeployException(String.format("Failed to deploy service '%s'.", service.getDeployPath()), (Throwable)t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            if (openApiObjectMapperHack != null) {
                openApiObjectMapperHack.revert();
            }
        }
    }

    private OpenApiFeature getOpenAPIv3Feature(Class<?> serviceClass, final OpenLService service) throws Exception {
        ((JaxrsOpenApiContextBuilder)new JaxrsOpenApiContextBuilder().configLocation("openapi-configuration-default.json")).buildContext(true);
        OpenApiFeature openApiFeature = new OpenApiFeature();
        openApiFeature.setUseContextBasedConfig(true);
        String configLocation = this.env.getProperty("openApi.configuration.location", "openapi-configuration.json");
        if (!new FileOpenApiConfigurationLoader().exists(configLocation) && !new ClasspathOpenApiConfigurationLoader().exists(configLocation) && this.authenticationEnabled) {
            configLocation = "openapi-security.json";
        }
        openApiFeature.setConfigLocation(configLocation);
        openApiFeature.setScan(false);
        openApiFeature.setResourcePackages(Collections.singleton(serviceClass.getPackage().getName()));
        openApiFeature.setCustomizer(new OpenApiCustomizer(){

            public OpenAPIConfiguration customize(OpenAPIConfiguration configuration) {
                if (configuration.getOpenAPI().getInfo() == null) {
                    configuration.getOpenAPI().info(new Info().description("Auto-generated OpenAPI schema from the OpenL rules").version("1.0.0"));
                }
                configuration.getOpenAPI().getInfo().setTitle(service.getName());
                this.dynamicBasePath = true;
                return super.customize(configuration);
            }
        });
        return openApiFeature;
    }

    public OpenLService getServiceByDeploy(String deployPath) {
        Objects.requireNonNull(deployPath, "deployPath cannot be null");
        for (OpenLService service : this.runningServices.keySet()) {
            if (!Objects.equals(service.getDeployPath(), deployPath)) continue;
            return service;
        }
        return null;
    }

    public void undeploy(OpenLService service) throws RuleServiceUndeployException {
        Objects.requireNonNull(service, "service cannot be null");
        Server server = this.runningServices.get(service);
        if (server == null) {
            throw new RuleServiceUndeployException(String.format("There is no running service with name '%s'.", service.getDeployPath()));
        }
        try {
            server.destroy();
            this.runningServices.remove(service);
            this.log.info("Service '{}' has been undeployed successfully.", (Object)service.getDeployPath());
        }
        catch (Exception t) {
            throw new RuleServiceUndeployException(String.format("Failed to undeploy service '%s'.", service.getDeployPath()), (Throwable)t);
        }
    }

    public String getUrl(OpenLService service) {
        Object url = URLHelper.processURL((String)service.getUrl());
        int numOfServicesWithUrls = service.getPublishers().size();
        if (service.getPublishers().contains(RulesDeploy.PublisherType.KAFKA.toString())) {
            --numOfServicesWithUrls;
        }
        if (service.getPublishers().contains(RulesDeploy.PublisherType.RMI.toString())) {
            --numOfServicesWithUrls;
        }
        if (numOfServicesWithUrls != 1) {
            url = REST_PREFIX + (String)url;
        }
        return url;
    }

    public String name() {
        return "RESTFUL";
    }
}

