/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.openl.util.StringUtils;

public class TextPlainMessageProvider
implements MessageBodyWriter,
MessageBodyReader {
    private static final Set<Class<?>> DATE_TYPE_SET = new HashSet();
    private final ObjectMapper objectMapper;

    public TextPlainMessageProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isWriteable(Class aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return this.isAcceptable(aClass, mediaType);
    }

    public boolean isReadable(Class aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return this.isAcceptable(aClass, mediaType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAcceptable(Class aClass, MediaType mediaType) {
        if (!MediaType.TEXT_PLAIN_TYPE.isCompatible(mediaType)) return false;
        if (!DATE_TYPE_SET.stream().anyMatch(aClass::isAssignableFrom)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readFrom(Class aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        try {
            String str = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            Object object = this.objectMapper.readValue(this.quote(str), aClass);
            return object;
        }
        finally {
            inputStream.close();
        }
    }

    public void writeTo(Object o, Class aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, OutputStream outputStream) throws IOException {
        String str = this.unquote(this.objectMapper.writeValueAsString(o));
        outputStream.write(str.getBytes(StandardCharsets.UTF_8));
    }

    private String quote(String str) {
        return "\"" + str + "\"";
    }

    private String unquote(String str) {
        if (StringUtils.isEmpty((CharSequence)str) || !str.startsWith("\"") || !str.endsWith("\"")) {
            return str;
        }
        return str.substring(1, str.length() - 1);
    }

    static {
        DATE_TYPE_SET.add(Double.class);
        DATE_TYPE_SET.add(Double.TYPE);
        DATE_TYPE_SET.add(Float.class);
        DATE_TYPE_SET.add(Float.TYPE);
        DATE_TYPE_SET.add(BigDecimal.class);
        DATE_TYPE_SET.add(Date.class);
        DATE_TYPE_SET.add(Instant.class);
        DATE_TYPE_SET.add(ZonedDateTime.class);
        DATE_TYPE_SET.add(LocalDateTime.class);
        DATE_TYPE_SET.add(LocalDate.class);
        DATE_TYPE_SET.add(LocalTime.class);
    }
}

