/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.jaxrs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.openl.rules.ruleservice.publish.jaxrs.JAXRSOpenLServiceEnhancerHelper;
import org.openl.runtime.AbstractOpenLMethodHandler;

public class JAXRSMethodHandler
extends AbstractOpenLMethodHandler<Method, Method> {
    private final Object target;
    private final Map<Method, Method> methodMap;

    public Method getTargetMember(Method key) {
        return this.methodMap.get(key);
    }

    public JAXRSMethodHandler(Object target, Map<Method, Method> methodMap) {
        this.target = Objects.requireNonNull(target, "target cannot be null");
        this.methodMap = Objects.requireNonNull(methodMap, "methodMap cannot be null");
    }

    public Object getTarget() {
        return this.target;
    }

    public Object invoke(Method method, Object[] args) throws Exception {
        Object o;
        Method m = this.methodMap.get(method);
        if (m == null) {
            throw new IllegalStateException("Method is not found in the map of methods.");
        }
        if (args != null && args.length > 0 && method.getParameterCount() != m.getParameterCount()) {
            Object requestObject = args[0];
            Object[] newArgs = new Object[m.getParameterCount()];
            Object[] requestWrapperArgs = null;
            if (requestObject != null) {
                requestWrapperArgs = (Object[])requestObject.getClass().getMethod("_args", new Class[0]).invoke(requestObject, new Object[0]);
            }
            int i = 0;
            int j = 1;
            int k = 0;
            for (Parameter parameter : m.getParameters()) {
                newArgs[i] = JAXRSOpenLServiceEnhancerHelper.isParameterInWrapperClass((Parameter)parameter) ? (requestWrapperArgs != null ? requestWrapperArgs[k++] : null) : args[j++];
                ++i;
            }
            args = newArgs;
        }
        try {
            o = m.invoke(this.target, args);
        }
        catch (InvocationTargetException | UndeclaredThrowableException e) {
            Throwable ex = e.getCause();
            throw ex instanceof Exception ? (Exception)ex : e;
        }
        if (o instanceof Response) {
            return o;
        }
        return Response.status((Response.Status)(o == null ? Response.Status.NO_CONTENT : Response.Status.OK)).entity(o).build();
    }
}

