/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.jaxrs;

import java.util.Map;
import java.util.Objects;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.publish.jaxrs.JAXRSMethodHandler;
import org.openl.rules.ruleservice.publish.jaxrs.JAXRSOpenLServiceEnhancerHelper;
import org.openl.runtime.ASMProxyFactory;
import org.openl.runtime.ASMProxyHandler;

public final class JAXRSOpenLServiceEnhancer {
    public Object decorateServiceBean(OpenLService service) throws Exception {
        Class serviceClass = service.getServiceClass();
        Objects.requireNonNull(serviceClass, "Service class cannot be null");
        ClassLoader classLoader = service.getClassLoader();
        Class enhancedServiceClass = JAXRSOpenLServiceEnhancerHelper.enhanceInterface((Class)serviceClass, (Object)service.getServiceBean(), (ClassLoader)classLoader, (boolean)service.isProvideRuntimeContext(), (boolean)service.isProvideVariations());
        if (enhancedServiceClass.getPackage() == null) {
            throw new IllegalStateException("Package cannot be null");
        }
        Map methodMap = JAXRSOpenLServiceEnhancerHelper.buildMethodMap((Class)serviceClass, (Class)enhancedServiceClass);
        return ASMProxyFactory.newProxyInstance((ClassLoader)classLoader, (ASMProxyHandler)new JAXRSMethodHandler(service.getServiceBean(), methodMap), (Class)enhancedServiceClass);
    }
}

