/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.jaxrs.swagger;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.UriInfo;
import org.openl.rules.ruleservice.publish.jaxrs.swagger.OpenApiObjectMapperHack;
import org.openl.rules.ruleservice.publish.jaxrs.swagger.OpenApiRulesCacheWorkaround;

@PreMatching
@Priority(value=3000)
public final class OpenApiHackContainerRequestFilter
implements ContainerRequestFilter {
    private static final String OPENAPI_LISTING_PATH_JSON = "openapi.json";
    private static final String OPENAPI_LISTING_PATH_YAML = "openapi.yaml";
    private final ObjectMapper objectMapper;
    private static final ReentrantLock lock = new ReentrantLock();

    public OpenApiHackContainerRequestFilter(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper cannot be null");
    }

    public void filter(ContainerRequestContext requestContext) {
        UriInfo ui = requestContext.getUriInfo();
        if (ui.getPath().endsWith(OPENAPI_LISTING_PATH_JSON) || ui.getPath().endsWith(OPENAPI_LISTING_PATH_YAML)) {
            OpenApiObjectMapperHack openApiObjectMapperHack = new OpenApiObjectMapperHack();
            requestContext.setProperty("OpenApiHackContainerRequestFilterLock", (Object)lock);
            lock.lock();
            openApiObjectMapperHack.apply(this.objectMapper);
            OpenApiRulesCacheWorkaround.reset();
            requestContext.setProperty("OpenApiObjectMapperHack", (Object)openApiObjectMapperHack);
        }
    }
}

