/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.rest;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.openl.info.OpenLVersion;
import org.openl.info.SysInfo;
import org.openl.rules.ruleservice.loader.DeployClasspathJarsBean;
import org.openl.rules.ruleservice.servlet.ServiceInfo;
import org.openl.rules.ruleservice.servlet.ServiceInfoProvider;
import org.openl.spring.env.DefaultPropertySource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Produces(value={"application/json"})
public class AdminRestController {
    @Autowired
    private DeployClasspathJarsBean deployClasspathJarService;
    @Autowired
    private ServiceInfoProvider serviceManager;
    @Value(value="#{uiConfig}")
    private Map<String, Object> uiConfig;

    @GET
    @Path(value="/services")
    public Response getServiceInfo() {
        return Response.ok((Object)this.serviceManager.getServicesInfo()).build();
    }

    @GET
    @Path(value="/ui/info")
    public Response getServiceInfoWithSettings() {
        HashMap<String, Object> info = new HashMap<String, Object>(this.uiConfig);
        info.put("services", this.serviceManager.getServicesInfo());
        return Response.ok(info).build();
    }

    @GET
    @Path(value="/info/sys.json")
    public Response getSysInfo() {
        return Response.ok((Object)SysInfo.get()).build();
    }

    @GET
    @Path(value="/info/openl.json")
    public Response getOpenLInfo() {
        return Response.ok((Object)OpenLVersion.get()).build();
    }

    @GET
    @Path(value="/services/{deployPath:.+}/errors/")
    public Response getServiceErrors(@PathParam(value="deployPath") String deployPath) {
        return AdminRestController.okOrNotFound(this.serviceManager.getServiceErrors(deployPath));
    }

    @GET
    @Path(value="/services/{deployPath:.+}/MANIFEST.MF")
    public Response getManifest(@PathParam(value="deployPath") String deployPath) {
        return AdminRestController.okOrNotFound(this.serviceManager.getManifest(deployPath));
    }

    @GET
    @Path(value="/healthcheck/readiness")
    public Response readiness() {
        if (!this.deployClasspathJarService.isDone()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        Collection servicesInfo = this.serviceManager.getServicesInfo();
        if (servicesInfo.isEmpty()) {
            return this.serviceManager.isReady() ? Response.ok((Object)"EMPTY", (MediaType)MediaType.TEXT_PLAIN_TYPE).build() : Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        boolean anyFailed = servicesInfo.stream().anyMatch(info -> ServiceInfo.ServiceStatus.FAILED.equals((Object)info.getStatus()));
        return anyFailed ? Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build() : Response.ok((Object)"READY", (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    @GET
    @Path(value="/healthcheck/startup")
    public Response startup() {
        return Response.ok((Object)"UP", (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    @GET
    @Path(value="/swagger-ui.json")
    public Response swaggerUIConfig() {
        List urls = this.serviceManager.getServicesInfo().stream().filter(k -> this.getRestUrl((ServiceInfo)k) != null).map(k -> Map.of("name", k.getName(), "url", this.getRestUrl((ServiceInfo)k) + "/openapi.json")).collect(Collectors.toList());
        return Response.ok(Map.of("urls", urls)).build();
    }

    private String getRestUrl(ServiceInfo k) {
        return (String)k.getUrls().get("RESTFUL");
    }

    private static Response okOrNotFound(Object entity) {
        return Response.status((Response.Status)(entity == null ? Response.Status.NOT_FOUND : Response.Status.OK)).entity(entity).build();
    }

    @GET
    @Path(value="/info/build.json")
    public Response getBuildInfo() {
        return Response.ok((Object)OpenLVersion.getBuildInfo()).build();
    }

    @GET
    @Path(value="/config/application.properties")
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response getApplicationProperties() {
        return Response.ok(DefaultPropertySource::transferAllOpenLDefaultProperties).build();
    }
}

