/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.rest;

import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.deployer.RulesDeployerService;
import org.openl.rules.ruleservice.loader.DeploymentsUpdatedEvent;
import org.openl.rules.ruleservice.management.ServiceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@Path(value="/deploy")
@Produces(value={"application/json"})
public class RulesDeployerRestController {
    @Autowired
    private RulesDeployerService rulesDeployerService;
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response deploy(@Context HttpServletRequest request) throws Exception {
        try {
            this.rulesDeployerService.deploy((InputStream)request.getInputStream(), true);
            this.notifyDeploymentsUpdated();
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/{deployPath:.+}")
    @Consumes(value={"application/zip"})
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response deploy(@PathParam(value="deployPath") String deployPath, @Context HttpServletRequest request) throws Exception {
        try {
            this.rulesDeployerService.deploy(deployPath, (InputStream)request.getInputStream(), true);
            this.notifyDeploymentsUpdated();
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/{deploymentName}.zip")
    @Produces(value={"application/zip"})
    public Response read(@PathParam(value="deploymentName") String deploymentName) throws Exception {
        Collection services = this.serviceManager.getServicesByDeployment(deploymentName);
        if (services.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String encodedFileName = URLEncoder.encode(deploymentName + ".zip", StandardCharsets.UTF_8.name()).replace("+", "%20");
        return Response.ok(outputStream -> this.rulesDeployerService.read(deploymentName, services.stream().map(OpenLService::getDeployPath).collect(Collectors.toSet()), outputStream)).header("Content-Disposition", (Object)("attachment; filename='" + encodedFileName + "'; filename*=UTF-8''" + encodedFileName)).build();
    }

    @DELETE
    @Path(value="/{deploymentName}")
    public Response delete(@PathParam(value="deploymentName") String deploymentName) throws Exception {
        Collection services = this.serviceManager.getServicesByDeployment(deploymentName);
        if (services.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        boolean deleted = this.rulesDeployerService.delete(deploymentName, services.stream().map(OpenLService::getDeployPath).collect(Collectors.toSet()));
        if (deleted) {
            this.notifyDeploymentsUpdated();
        }
        return Response.status((Response.Status)(deleted ? Response.Status.OK : Response.Status.NOT_FOUND)).build();
    }

    private void notifyDeploymentsUpdated() {
        this.eventPublisher.publishEvent((ApplicationEvent)new DeploymentsUpdatedEvent((Object)this));
    }
}

