/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.servlet;

import de.qaware.xff.filter.ForwardedHeaderFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.FileNameMap;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openl.info.OpenLInfoLogger;
import org.openl.rules.ruleservice.api.AccessDeniedHandler;
import org.openl.rules.ruleservice.api.AuthorizationChecker;
import org.openl.rules.ruleservice.core.RuleServiceRedeployLock;
import org.openl.rules.ruleservice.servlet.SpringInitializer;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;

@WebFilter(value={"/*"}, initParams={@WebInitParam(name="xForwardedPrefixStrategy", value="PREPEND")})
public class RuleServicesFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(RuleServicesFilter.class);
    private static final Pattern ALLOWED_PATH = Pattern.compile("/[a-zA-Z0-9_-]+([./][a-zA-Z0-9_-]+)*");
    private Filter xForwardedFilter;
    private FileNameMap mimeMap;
    public static final String REQUEST_ID_KEY = "requestId";
    private String requestIdHeaderKey;
    private AuthorizationChecker[] authorizationCheckers;
    private AccessDeniedHandler accessDeniedHandler;
    private String[] allowedOrigins;
    private boolean allowedAny;
    private String allowedMethods;
    private String allowedHeaders;
    private String maxAge;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.xForwardedFilter = new ForwardedHeaderFilter();
        this.xForwardedFilter.init(filterConfig);
        ServletContext servletContext = filterConfig.getServletContext();
        this.mimeMap = arg_0 -> ((ServletContext)servletContext).getMimeType(arg_0);
        ApplicationContext appContext = SpringInitializer.getApplicationContext(servletContext);
        Environment env = appContext.getEnvironment();
        this.requestIdHeaderKey = StringUtils.trimToNull((String)env.getProperty("log.request-id.header"));
        Object[] checkers = appContext.getBeansOfType(AuthorizationChecker.class).values().toArray(new AuthorizationChecker[0]);
        Arrays.sort(checkers, AnnotationAwareOrderComparator.INSTANCE);
        this.log.info("Available Authorization checkers: {}", (Object)Arrays.toString(checkers));
        this.authorizationCheckers = checkers;
        this.accessDeniedHandler = (AccessDeniedHandler)appContext.getBeansOfType(AccessDeniedHandler.class).values().iterator().next();
        String allowed = env.getProperty("cors.allowed.origins");
        this.allowedAny = "*".equals(allowed);
        this.allowedOrigins = StringUtils.split((String)allowed, (char)',');
        this.allowedMethods = env.getProperty("cors.allowed.methods");
        this.allowedHeaders = env.getProperty("cors.allowed.headers");
        this.maxAge = env.getProperty("cors.preflight.maxage");
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        this.xForwardedFilter.doFilter(req, resp, (request, response) -> this.processForwarded(request, response, chain));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processForwarded(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        if (this.requestIdHeaderKey != null) {
            String requestId = request.getHeader(this.requestIdHeaderKey);
            if (StringUtils.isBlank((CharSequence)requestId)) {
                requestId = UUID.randomUUID().toString();
            }
            response.setHeader(this.requestIdHeaderKey, requestId);
            MDC.put((String)REQUEST_ID_KEY, (String)requestId);
            try {
                this.process(request, response, chain);
            }
            finally {
                MDC.remove((String)REQUEST_ID_KEY);
            }
        } else {
            this.process(request, response, chain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestOrigin;
        String method = request.getMethod();
        String path = request.getPathInfo();
        if (path == null || path.equals("/")) {
            path = "/index.html";
        }
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("UTF-8");
        }
        if (method.equals("GET") && RuleServicesFilter.isAllowedPath(path)) {
            try (InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream("static" + path);){
                if (resourceStream != null) {
                    response.setStatus(200);
                    String mimeType = this.mimeMap.getContentTypeFor(path);
                    response.setContentType(mimeType);
                    resourceStream.transferTo((OutputStream)response.getOutputStream());
                    return;
                }
            }
        }
        if (this.authorizationCheckers.length > 0 && !this.skipAuthorization(path)) {
            boolean authorized = false;
            try {
                for (AuthorizationChecker validator : this.authorizationCheckers) {
                    if (!validator.authorize(request)) continue;
                    this.log.debug("Authorized: {} {}; by: {}", new Object[]{method, request.getRequestURL(), validator});
                    authorized = true;
                    break;
                }
            }
            catch (Exception e) {
                this.log.warn("Authorization failure.", (Throwable)e);
            }
            if (!authorized) {
                this.accessDeniedHandler.handle(request, response);
                return;
            }
        }
        if (this.isAllowedOrigin(requestOrigin = request.getHeader("Origin"))) {
            response.addHeader("Access-Control-Allow-Origin", requestOrigin);
            response.addHeader("Access-Control-Max-Age", this.maxAge);
            response.addHeader("Access-Control-Allow-Methods", this.allowedMethods);
            response.addHeader("Access-Control-Allow-Headers", this.allowedHeaders);
            if ("OPTIONS".equals(method)) {
                response.setStatus(202);
                return;
            }
        }
        if (path.startsWith("/admin/")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Lock lock = RuleServiceRedeployLock.getInstance().getReadLock();
        try {
            lock.lock();
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            lock.unlock();
        }
    }

    private boolean skipAuthorization(String path) {
        return path.startsWith("/admin/healthcheck/") || path.startsWith("/admin/info/") || path.startsWith("/admin/config/");
    }

    static boolean isAllowedPath(String path) {
        return ALLOWED_PATH.matcher(path).matches();
    }

    private boolean isAllowedOrigin(String requestOrigin) {
        if (requestOrigin == null || this.allowedOrigins == null) {
            return false;
        }
        if (this.allowedAny) {
            return true;
        }
        for (String allowed : this.allowedOrigins) {
            if (!allowed.equalsIgnoreCase(requestOrigin)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        OpenLInfoLogger.memStat();
        this.authorizationCheckers = null;
        this.accessDeniedHandler = null;
        this.mimeMap = null;
        this.xForwardedFilter.destroy();
        this.xForwardedFilter = null;
    }
}

