/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.openl.rules.openapi.OpenAPIConfiguration;
import org.openl.spring.env.PropertySourcesLoader;
import org.openl.util.ClassUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@WebListener
public final class SpringInitializer
implements ServletContextListener {
    private static final String THIS = SpringInitializer.class.getName();
    private ClassPathXmlApplicationContext applicationContext;

    public static ApplicationContext getApplicationContext(ServletContext sc) {
        return ((SpringInitializer)sc.getAttribute((String)SpringInitializer.THIS)).applicationContext;
    }

    public void contextInitialized(ServletContextEvent sce) {
        OpenAPIConfiguration.configure();
        ServletContext servletContext = sce.getServletContext();
        servletContext.log("Initializing Spring root ApplicationContext");
        this.applicationContext = new ClassPathXmlApplicationContext();
        this.applicationContext.setId("OpenL_RuleService");
        this.applicationContext.setClassLoader(ClassUtils.getCurrentClassLoader(this.getClass()));
        this.applicationContext.setConfigLocations(new String[]{"classpath:openl-ruleservice-ws-beans.xml"});
        new PropertySourcesLoader().initialize((ConfigurableApplicationContext)this.applicationContext, servletContext);
        this.applicationContext.refresh();
        this.applicationContext.registerShutdownHook();
        servletContext.setAttribute(THIS, (Object)this);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        servletContext.removeAttribute(THIS);
        this.applicationContext.close();
    }
}

