/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.spring;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openl.rules.ruleservice.api.AccessDeniedHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order
@Component
public class BasicAccessDeniedHandler
implements AccessDeniedHandler {
    private final Logger log = LoggerFactory.getLogger(BasicAccessDeniedHandler.class);

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.log.info("Access denied: {} {};", (Object)request.getMethod(), (Object)request.getRequestURL());
        String credentials = request.getHeader("Authorization");
        if (credentials == null) {
            response.setStatus(401);
            response.addHeader("WWW-Authenticate", "Basic");
        } else {
            response.setStatus(403);
        }
    }
}

