/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.spring;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.openl.rules.ruleservice.api.AuthorizationChecker;
import org.openl.spring.config.ConditionalOnEnable;
import org.openl.util.CollectionUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnEnable(value={"ruleservice.authentication.enabled"})
public class JWTValidator
implements AuthorizationChecker {
    private static final String BEARER = "Bearer ";
    private final Logger log = LoggerFactory.getLogger(JWTValidator.class);
    private final JwtConsumer jwtConsumer;

    @Autowired
    public JWTValidator(Environment env) throws JoseException, IOException {
        JwtConsumer jwtConsumer;
        HttpsJwksVerificationKeyResolver jwksResolver;
        Object[] expectedIssuers = StringUtils.split((String)env.getProperty("ruleservice.authentication.iss"), (char)',');
        if (CollectionUtils.isEmpty((Object[])expectedIssuers)) {
            throw new IllegalArgumentException("The 'ruleservice.authentication.iss' property should contain an issuer id");
        }
        String jwkPropertyUrl = env.getProperty("ruleservice.authentication.jwks");
        if (StringUtils.isEmpty((CharSequence)jwkPropertyUrl)) {
            throw new IllegalArgumentException("The 'ruleservice.authentication.jwks' property should contain valid URL");
        }
        if (jwkPropertyUrl.startsWith("https:")) {
            jwksResolver = new HttpsJwksVerificationKeyResolver(new HttpsJwks(jwkPropertyUrl));
        } else {
            try (InputStream resource = new URL(jwkPropertyUrl).openStream();){
                String json = new String(resource.readAllBytes(), StandardCharsets.UTF_8);
                JsonWebKeySet jwks = new JsonWebKeySet(json);
                jwksResolver = new JwksVerificationKeyResolver(jwks.getJsonWebKeys());
            }
        }
        this.jwtConsumer = jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(30).setExpectedIssuer(env.getProperty("ruleservice.authentication.iss")).setExpectedAudience(StringUtils.split((String)env.getProperty("ruleservice.authentication.aud"), (char)',')).setVerificationKeyResolver((VerificationKeyResolver)jwksResolver).setJwsAlgorithmConstraints(AlgorithmConstraints.DISALLOW_NONE).build();
    }

    @Override
    public boolean authorize(HttpServletRequest httpRequest) {
        String pathInfo = httpRequest.getPathInfo();
        if (pathInfo.startsWith("/admin/")) {
            return true;
        }
        if (pathInfo.endsWith("openapi.json") || pathInfo.endsWith("openapi.yaml")) {
            return true;
        }
        String credentials = httpRequest.getHeader("Authorization");
        if (credentials == null) {
            this.log.warn("Authorization header is not present.");
            return false;
        }
        if (!credentials.regionMatches(true, 0, BEARER, 0, BEARER.length())) {
            this.log.warn("Bearer token is not present.");
            return false;
        }
        try {
            JwtClaims jwtClaims = this.jwtConsumer.processToClaims(credentials.substring(BEARER.length()));
            this.log.info("Authorized for JWT ID={}", (Object)jwtClaims.getJwtId());
        }
        catch (Exception e) {
            this.log.warn("Unexpected exception", (Throwable)e);
            return false;
        }
        return true;
    }
}

