/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.spring;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.openl.rules.ruleservice.core.ExceptionType;
import org.openl.rules.ruleservice.core.RuleServiceWrapperException;
import org.openl.rules.ruleservice.publish.jaxrs.JAXRSErrorResponse;
import org.springframework.stereotype.Component;

@Component
@Provider
public class RuleServiceExceptionMapper
implements ExceptionMapper<RuleServiceWrapperException> {
    public Response toResponse(RuleServiceWrapperException wrapperException) {
        int status;
        Object errorResponse;
        ExceptionType type = wrapperException.getType();
        String message = wrapperException.getMessage();
        switch (type) {
            case VALIDATION: {
                errorResponse = new JAXRSErrorResponse(message, type);
                status = 422;
                break;
            }
            case USER_ERROR: {
                errorResponse = wrapperException.getBody();
                status = 422;
                break;
            }
            default: {
                status = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
                errorResponse = new JAXRSErrorResponse(message, type);
            }
        }
        return Response.status((int)status).type("application/json").entity(errorResponse).build();
    }
}

