/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.spring;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openl.rules.ruleservice.core.ExceptionType;
import org.openl.rules.ruleservice.publish.jaxrs.JAXRSErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
public class SystemExceptionMapper
implements ExceptionMapper<Exception> {
    private final Logger log = LoggerFactory.getLogger(SystemExceptionMapper.class);

    public Response toResponse(Exception exception) {
        this.log.error("Something went wrong...", (Throwable)exception);
        ExceptionType type = ExceptionType.SYSTEM;
        String message = ExceptionUtils.getRootCauseMessage((Throwable)exception);
        JAXRSErrorResponse errorResponse = new JAXRSErrorResponse(message, type);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity((Object)errorResponse).build();
    }
}

