/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.spring;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.openl.rules.ruleservice.core.ExceptionType;
import org.openl.rules.ruleservice.publish.jaxrs.JAXRSErrorResponse;
import org.springframework.stereotype.Component;

@Component
@Provider
public class WebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    public Response toResponse(WebApplicationException exception) {
        String message;
        Response response = exception.getResponse();
        if (response != null && response.hasEntity()) {
            return response;
        }
        if (response == null) {
            response = Response.serverError().build();
        }
        String originalMessage = exception.getMessage();
        Throwable cause = exception.getCause();
        String string = message = cause != null ? cause.getMessage() : originalMessage;
        if (message == null) {
            message = cause != null ? cause.getClass().getName() : exception.getClass().getName();
        }
        return JAXRSUtils.fromResponse((Response)response, (boolean)false).type("application/json").entity((Object)new JAXRSErrorResponse(message, ExceptionType.SYSTEM)).build();
    }
}

