/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.storelogdata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.cxf.io.CachedOutputStream;

class CacheAndWriteOutputStream
extends CachedOutputStream {
    private final OutputStream flowThroughStream;
    private final ByteArrayOutputStream flowThroughStreamCache = new ByteArrayOutputStream();
    private long count;
    private long limit = Long.MAX_VALUE;

    public CacheAndWriteOutputStream(OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream may not be null");
        }
        this.flowThroughStream = stream;
    }

    public void setCacheLimit(long l) {
        this.limit = l;
    }

    protected void onWrite() {
    }

    public void copyCacheToFlowThroughStream() throws IOException {
        this.flowThroughStreamCache.flush();
        this.flowThroughStream.write(this.flowThroughStreamCache.toByteArray());
        this.flowThroughStream.close();
        this.flowThroughStreamCache.reset();
    }

    public void write(int b) throws IOException {
        this.flowThroughStreamCache.write(b);
        if (this.count <= this.limit) {
            super.write(b);
        }
        ++this.count;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.flowThroughStreamCache.write(b, off, len);
        if (this.count <= this.limit) {
            super.write(b, off, len);
        }
        this.count += (long)len;
    }

    public void write(byte[] b) throws IOException {
        this.flowThroughStreamCache.write(b);
        if (this.count <= this.limit) {
            super.write(b);
        }
        this.count += (long)b.length;
    }
}

