/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.storelogdata;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.openl.rules.ruleservice.storelogdata.StoreLogData;
import org.openl.rules.ruleservice.storelogdata.StoreLogDataHolder;

@NoJSR250Annotations
public class CollectRequestMessageInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String ID_KEY = CollectRequestMessageInInterceptor.class.getName() + ".ID";

    public CollectRequestMessageInInterceptor() {
        super("receive");
    }

    static boolean isBinaryContent(String contentType) {
        return contentType != null && (contentType.startsWith("image/") || contentType.equals("application/octet-stream"));
    }

    public void handleMessage(Message message) {
        this.processMessage(message);
    }

    public void handleFault(Message message) {
        StoreLogData storeLogData = StoreLogDataHolder.get();
        storeLogData.fault();
        this.processMessage(message);
    }

    protected void processMessage(Message message) {
        if (message.containsKey((Object)ID_KEY)) {
            return;
        }
        String id = (String)message.getExchange().get((Object)ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put((Object)ID_KEY, (Object)id);
        }
        message.put((Object)ID_KEY, (Object)id);
        LoggingMessage buffer = new LoggingMessage("Request", id);
        CollectRequestMessageInInterceptor.append(message.get((Object)Message.RESPONSE_CODE), buffer.getResponseCode());
        CollectRequestMessageInInterceptor.append(message.get((Object)Message.ENCODING), buffer.getEncoding());
        CollectRequestMessageInInterceptor.append(message.get((Object)"org.apache.cxf.request.method"), buffer.getHttpMethod());
        CollectRequestMessageInInterceptor.append(message.get((Object)"Content-Type"), buffer.getContentType());
        CollectRequestMessageInInterceptor.append(message.get((Object)Message.PROTOCOL_HEADERS), buffer.getHeader());
        Object uri = (String)message.get((Object)"org.apache.cxf.request.url");
        if (uri == null) {
            String address = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
            uri = (String)message.get((Object)"org.apache.cxf.request.uri");
            if (uri != null && ((String)uri).startsWith("/")) {
                if (address != null && !address.startsWith((String)uri)) {
                    uri = address + (String)uri;
                }
            } else {
                uri = address;
            }
        }
        if (uri != null) {
            buffer.getAddress().append((String)uri);
            String query = (String)message.get((Object)Message.QUERY_STRING);
            if (query != null) {
                buffer.getAddress().append("?").append(query);
            }
        }
        if (CollectRequestMessageInInterceptor.isBinaryContent((String)message.get((Object)"Content-Type"))) {
            buffer.getMessage().append("--- Binary Content ---").append('\n');
            this.handleMessage(buffer);
            return;
        }
        InputStream is = (InputStream)message.getContent(InputStream.class);
        if (is != null) {
            this.logInputStream(message, is, buffer, (String)message.get((Object)Message.ENCODING));
        } else {
            Reader reader = (Reader)message.getContent(Reader.class);
            if (reader != null) {
                this.logReader(message, reader, buffer);
            }
        }
        this.handleMessage(buffer);
    }

    private static void append(Object headers, StringBuilder builder) {
        if (headers != null) {
            builder.append(headers);
        }
    }

    private void handleMessage(LoggingMessage loggingMessage) {
        StoreLogData storeLogData = StoreLogDataHolder.get();
        storeLogData.setRequestMessage(loggingMessage);
        storeLogData.setIncomingMessageTime(ZonedDateTime.now());
    }

    protected void logReader(Message message, Reader reader, LoggingMessage buffer) {
        try {
            CachedWriter writer = new CachedWriter();
            IOUtils.copyAndCloseInput((Reader)reader, (Writer)writer);
            message.setContent(Reader.class, (Object)writer.getReader());
            writer.writeCacheTo(buffer.getPayload());
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private void logInputStream(Message message, InputStream is, LoggingMessage buffer, String encoding) {
        try (CachedOutputStream bos = new CachedOutputStream();){
            InputStream bis = is instanceof DelegatingInputStream ? ((DelegatingInputStream)is).getInputStream() : is;
            bis.transferTo((OutputStream)bos);
            bos.flush();
            bis = new SequenceInputStream(bos.getInputStream(), bis);
            if (is instanceof DelegatingInputStream) {
                ((DelegatingInputStream)is).setInputStream(bis);
            } else {
                message.setContent(InputStream.class, (Object)bis);
            }
            bos.writeCacheTo(buffer.getPayload(), Objects.requireNonNullElseGet(encoding, StandardCharsets.UTF_8::name));
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }
}

