/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.storelogdata;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.openl.rules.ruleservice.storelogdata.CacheAndWriteOutputStream;
import org.openl.rules.ruleservice.storelogdata.CollectRequestMessageInInterceptor;
import org.openl.rules.ruleservice.storelogdata.StoreLogData;
import org.openl.rules.ruleservice.storelogdata.StoreLogDataException;
import org.openl.rules.ruleservice.storelogdata.StoreLogDataHolder;
import org.openl.rules.ruleservice.storelogdata.StoreLogDataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoJSR250Annotations
public class CollectResponseMessageOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(CollectResponseMessageOutInterceptor.class);
    private final StoreLogDataManager storeLoggingManager;

    public StoreLogDataManager getStoreLoggingManager() {
        return this.storeLoggingManager;
    }

    public CollectResponseMessageOutInterceptor(StoreLogDataManager storeLoggingManager) {
        super("pre-stream");
        this.storeLoggingManager = storeLoggingManager;
    }

    public void handleMessage(Message message) {
        this.handleAnyMessage(message);
    }

    public void handleFault(Message message) {
        StoreLogData storeLogData = StoreLogDataHolder.get();
        storeLogData.fault();
    }

    private void handleAnyMessage(Message message) {
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        Writer iowriter = (Writer)message.getContent(Writer.class);
        if (os == null && iowriter == null) {
            return;
        }
        if (os != null) {
            if (this.storeLoggingManager.isAtLeastOneSync(StoreLogDataHolder.get())) {
                CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
                message.setContent(OutputStream.class, (Object)newOut);
                newOut.registerCallback(new LoggingCallback(message, os));
            } else {
                org.apache.cxf.io.CacheAndWriteOutputStream newOut = new org.apache.cxf.io.CacheAndWriteOutputStream(os);
                message.setContent(OutputStream.class, (Object)newOut);
                newOut.registerCallback((CachedOutputStreamCallback)new LoggingCallback(message, os));
            }
        } else {
            message.setContent(Writer.class, (Object)new LogWriter(message, iowriter));
        }
    }

    private static LoggingMessage setupBuffer(Message message) {
        String id = (String)message.getExchange().get((Object)CollectRequestMessageInInterceptor.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put((Object)CollectRequestMessageInInterceptor.ID_KEY, (Object)id);
        }
        LoggingMessage buffer = new LoggingMessage("Response", id);
        CollectResponseMessageOutInterceptor.append(message.get((Object)Message.RESPONSE_CODE), buffer.getResponseCode());
        CollectResponseMessageOutInterceptor.append(message.get((Object)Message.ENCODING), buffer.getEncoding());
        CollectResponseMessageOutInterceptor.append(message.get((Object)"org.apache.cxf.request.method"), buffer.getHttpMethod());
        CollectResponseMessageOutInterceptor.append(message.get((Object)"Content-Type"), buffer.getContentType());
        CollectResponseMessageOutInterceptor.append(message.get((Object)Message.PROTOCOL_HEADERS), buffer.getHeader());
        String address = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
        if (address != null) {
            buffer.getAddress().append(address);
            String uri = (String)message.get((Object)"org.apache.cxf.request.uri");
            if (uri != null && !address.startsWith(uri)) {
                if (!address.endsWith("/") && !uri.startsWith("/")) {
                    buffer.getAddress().append("/");
                }
                buffer.getAddress().append(uri);
            }
        }
        return buffer;
    }

    private static void append(Object responseCode, StringBuilder builder) {
        if (responseCode != null) {
            builder.append(responseCode);
        }
    }

    private void handleMessage(LoggingMessage loggingMessage) throws Fault {
        StoreLogData storeLogData = StoreLogDataHolder.get();
        try {
            storeLogData.setResponseMessage(loggingMessage);
            storeLogData.setOutcomingMessageTime(ZonedDateTime.now());
            this.getStoreLoggingManager().store(storeLogData);
        }
        catch (StoreLogDataException e) {
            throw new Fault((Throwable)e);
        }
        finally {
            StoreLogDataHolder.remove();
        }
    }

    class LoggingCallback
    implements CachedOutputStreamCallback {
        private final Message message;
        private final OutputStream origStream;
        private final int lim;

        public LoggingCallback(Message msg, OutputStream os) {
            this.message = msg;
            this.origStream = os;
            this.lim = Integer.MAX_VALUE;
        }

        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            LoggingMessage buffer = CollectResponseMessageOutInterceptor.setupBuffer(this.message);
            String ct = (String)this.message.get((Object)"Content-Type");
            if (CollectRequestMessageInInterceptor.isBinaryContent(ct)) {
                buffer.getMessage().append("--- Binary Content ---").append('\n');
                CollectResponseMessageOutInterceptor.this.handleMessage(buffer);
                return;
            }
            try {
                String encoding = (String)this.message.get((Object)Message.ENCODING);
                cos.writeCacheTo(buffer.getPayload(), Objects.requireNonNullElseGet(encoding, StandardCharsets.UTF_8::name));
            }
            catch (Exception e) {
                LOG.debug("Error occurred: ", (Throwable)e);
            }
            Fault fault = null;
            try {
                CollectResponseMessageOutInterceptor.this.handleMessage(buffer);
            }
            catch (Fault f) {
                fault = f;
            }
            try {
                cos.lockOutputStream();
                cos.resetOut(null, false);
            }
            catch (Exception e) {
                LOG.debug("Ignored error: ", (Throwable)e);
            }
            this.message.setContent(OutputStream.class, (Object)this.origStream);
            if (fault != null) {
                throw fault;
            }
            if (cos instanceof CacheAndWriteOutputStream) {
                try {
                    ((CacheAndWriteOutputStream)cos).copyCacheToFlowThroughStream();
                }
                catch (Exception e) {
                    LOG.debug("Ignored error: ", (Throwable)e);
                }
            }
        }
    }

    private class LogWriter
    extends FilterWriter {
        StringWriter out2;
        int count;
        Message message;
        final int lim;

        public LogWriter(Message message, Writer writer) {
            super(writer);
            this.message = message;
            if (!(writer instanceof StringWriter)) {
                this.out2 = new StringWriter();
            }
            this.lim = Integer.MAX_VALUE;
        }

        @Override
        public void write(int c) throws IOException {
            super.write(c);
            if (this.out2 != null && this.count < this.lim) {
                this.out2.write(c);
            }
            ++this.count;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            super.write(cbuf, off, len);
            if (this.out2 != null && this.count < this.lim) {
                this.out2.write(cbuf, off, len);
            }
            this.count += len;
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            super.write(str, off, len);
            if (this.out2 != null && this.count < this.lim) {
                this.out2.write(str, off, len);
            }
            this.count += len;
        }

        @Override
        public void close() throws IOException {
            LoggingMessage buffer = CollectResponseMessageOutInterceptor.setupBuffer(this.message);
            StringWriter w2 = this.out2;
            if (w2 == null) {
                w2 = (StringWriter)this.out;
            }
            String ct = (String)this.message.get((Object)"Content-Type");
            try {
                StringBuilder builder = buffer.getPayload();
                StringBuffer buffer1 = w2.getBuffer();
                if (buffer1.length() > Integer.MAX_VALUE) {
                    builder.append(buffer1.subSequence(0, Integer.MAX_VALUE));
                } else {
                    builder.append(buffer1);
                }
            }
            catch (Exception e) {
                LOG.debug("Ignored error: ", (Throwable)e);
            }
            String id = (String)this.message.getExchange().get((Object)CollectRequestMessageInInterceptor.ID_KEY);
            LoggingMessage loggingMessage = new LoggingMessage(null, id);
            loggingMessage.getContentType().append(ct);
            loggingMessage.getPayload().append(buffer);
            CollectResponseMessageOutInterceptor.this.handleMessage(loggingMessage);
            this.message.setContent(Writer.class, (Object)this.out);
            super.close();
        }
    }
}

