/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.storelogdata;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationException;
import org.openl.rules.ruleservice.publish.jaxrs.storelogdata.JacksonObjectSerializer;
import org.openl.rules.ruleservice.storelogdata.ObjectSerializer;
import org.openl.rules.ruleservice.storelogdata.StoreLogData;
import org.openl.rules.ruleservice.storelogdata.StoreLogDataHolder;

public class PopulateStoreLogDataInterceptor
extends AbstractPhaseInterceptor<Message> {
    private final String serviceName;
    private final Class<?> serviceClass;
    private final ObjectSerializer objectSerializer;

    public PopulateStoreLogDataInterceptor(OpenLService service, ObjectMapper objectMapper) throws RuleServiceInstantiationException {
        super("pre-stream");
        this.serviceClass = service.getServiceClass();
        this.serviceName = service.getName();
        this.objectSerializer = new JacksonObjectSerializer(objectMapper);
    }

    public void handleMessage(Message message) {
        this.populateStoreLogData();
    }

    public void handleFault(Message message) {
        this.populateStoreLogData();
    }

    private void populateStoreLogData() {
        StoreLogData storeLogData = StoreLogDataHolder.get();
        storeLogData.setServiceClass(this.serviceClass);
        storeLogData.setServiceName(this.serviceName);
        storeLogData.setPublisherType(RulesDeploy.PublisherType.RESTFUL);
        storeLogData.setObjectSerializer(this.objectSerializer);
    }
}

