/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.storelogdata;

import java.util.Collection;
import java.util.Objects;
import org.openl.rules.ruleservice.storelogdata.StoreLogData;
import org.openl.rules.ruleservice.storelogdata.StoreLogDataException;
import org.openl.rules.ruleservice.storelogdata.StoreLogDataManager;
import org.openl.rules.ruleservice.storelogdata.StoreLogDataService;
import org.openl.rules.ruleservice.storelogdata.annotation.AnnotationUtils;
import org.openl.rules.ruleservice.storelogdata.annotation.SkipFault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleStoreLogDataManager
implements StoreLogDataManager {
    private final Logger log = LoggerFactory.getLogger(SimpleStoreLogDataManager.class);
    private final Collection<StoreLogDataService> storeLogDataServices;
    private final boolean enabled;

    public SimpleStoreLogDataManager(Collection<StoreLogDataService> storeLogDataServices) {
        Objects.requireNonNull(storeLogDataServices);
        this.storeLogDataServices = storeLogDataServices;
        this.enabled = !storeLogDataServices.isEmpty();
        storeLogDataServices.stream().map(x -> x.getClass().getTypeName()).forEach(x -> this.log.info("Store log data service '{}' is used.", x));
    }

    @Override
    public Collection<StoreLogDataService> getServices() {
        return this.storeLogDataServices;
    }

    @Override
    public void store(StoreLogData storeLogData) throws StoreLogDataException {
        if (!storeLogData.isIgnorable() && !this.ignoreByFault(storeLogData)) {
            for (StoreLogDataService storeLogDataService : this.storeLogDataServices) {
                storeLogDataService.save(storeLogData);
            }
        }
    }

    @Override
    public boolean isAtLeastOneSync(StoreLogData storeLogData) {
        for (StoreLogDataService storeLogDataService : this.storeLogDataServices) {
            if (!storeLogDataService.isSync(storeLogData)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private boolean ignoreByFault(StoreLogData storeLogData) {
        if (storeLogData.isFault()) {
            return AnnotationUtils.getAnnotationInServiceClassOrServiceMethod((StoreLogData)storeLogData, SkipFault.class) != null;
        }
        return false;
    }
}

