/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.storelogdata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.openl.binding.MethodUtil;
import org.openl.rules.ruleservice.core.interceptors.ServiceInvocationAdviceListener;
import org.openl.rules.ruleservice.core.interceptors.ServiceMethodAdvice;
import org.openl.rules.ruleservice.storelogdata.Inject;
import org.openl.rules.ruleservice.storelogdata.ObjectSerializer;
import org.openl.rules.ruleservice.storelogdata.StoreLogData;
import org.openl.rules.ruleservice.storelogdata.StoreLogDataHolder;
import org.openl.rules.ruleservice.storelogdata.StoreLogDataManager;
import org.openl.rules.ruleservice.storelogdata.StoreLogDataService;
import org.openl.rules.ruleservice.storelogdata.advice.ObjectSerializerAware;
import org.openl.rules.ruleservice.storelogdata.advice.StoreLogDataAdvice;
import org.openl.rules.ruleservice.storelogdata.annotation.InjectObjectSerializer;
import org.openl.rules.ruleservice.storelogdata.annotation.PrepareStoreLogData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StoreLogDataServiceInvocationAdviceListener
implements ServiceInvocationAdviceListener {
    private final Logger log = LoggerFactory.getLogger(StoreLogDataServiceInvocationAdviceListener.class);
    @Autowired
    private StoreLogDataManager storeLogDataManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Method interfaceMethod, Object[] args, Object result, Exception lastOccurredException, ServiceInvocationAdviceListener.Instantiator postProcessAdvice, Predicate<PrepareStoreLogData> predicate) {
        PrepareStoreLogData[] annotations = (PrepareStoreLogData[])interfaceMethod.getAnnotationsByType(PrepareStoreLogData.class);
        ArrayList<Runnable> destroyFunctions = new ArrayList<Runnable>();
        try {
            StoreLogData storeLogData = StoreLogDataHolder.get();
            IdentityHashMap cache = new IdentityHashMap();
            for (PrepareStoreLogData storeLogging : annotations) {
                if (!predicate.test(storeLogging)) continue;
                StoreLogDataAdvice storeLogDataAdvice = null;
                Class clazz = storeLogging.value();
                try {
                    storeLogDataAdvice = (StoreLogDataAdvice)postProcessAdvice.instantiate(clazz);
                    this.injectObjectSerializer(storeLogData.getObjectSerializer(), storeLogDataAdvice);
                    this.processAwareInterfaces(interfaceMethod, storeLogDataAdvice, cache, destroyFunctions);
                }
                catch (Exception e) {
                    String msg = String.format("Failed to instantiate store log data advice for method '%s'. Please, check that class '%s' is not abstract and has a default constructor.", MethodUtil.printQualifiedMethodName((Method)interfaceMethod), clazz.getTypeName());
                    this.log.error(msg, (Throwable)e);
                }
                if (storeLogDataAdvice == null) continue;
                storeLogDataAdvice.prepare(storeLogData.getCustomValues(), args, result, lastOccurredException);
            }
        }
        finally {
            destroyFunctions.forEach(Runnable::run);
        }
    }

    private void processAwareInterfaces(Method interfaceMethod, StoreLogDataAdvice storeLogDataAdvice, IdentityHashMap<Inject<?>, Object> cache, Collection<Runnable> destroyFunctions) {
        for (StoreLogDataService storeLogDataService : this.storeLogDataManager.getServices()) {
            for (Inject inject : storeLogDataService.additionalInjects()) {
                Class annotationClass = inject.getAnnotationClass();
                try {
                    Object resource = cache.get(inject);
                    if (resource == null) {
                        Object resource1 = this.inject(storeLogDataAdvice, annotationClass, e -> inject.getResource(interfaceMethod, e));
                        cache.put(inject, resource1);
                        if (resource1 == null) continue;
                        destroyFunctions.add(() -> inject.destroy(resource1));
                        continue;
                    }
                    this.inject(storeLogDataAdvice, annotationClass, e -> resource);
                }
                catch (IllegalAccessException | InvocationTargetException e2) {
                    this.log.error("Failed to inject a resource through annotation '{}'", (Object)annotationClass.getTypeName(), (Object)e2);
                }
            }
        }
    }

    private void injectObjectSerializer(ObjectSerializer objectSerializer, StoreLogDataAdvice storeLogDataAdvice) {
        if (storeLogDataAdvice instanceof ObjectSerializerAware) {
            ((ObjectSerializerAware)storeLogDataAdvice).setObjectSerializer(objectSerializer);
        }
        try {
            this.inject(storeLogDataAdvice, InjectObjectSerializer.class, e -> objectSerializer);
        }
        catch (IllegalAccessException | InvocationTargetException e2) {
            this.log.error("Failed to inject a resource through @InjectObjectSerializer annotation.", (Throwable)e2);
        }
    }

    private Object inject(Object target, Class<? extends Annotation> annotationClass, Function<Annotation, Object> supplier) throws IllegalAccessException, InvocationTargetException {
        if (annotationClass != null) {
            Annotation annotation;
            Object resource = null;
            boolean initialized = false;
            for (Class<?> cls = target.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
                for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
                    annotation = ((Field)accessibleObject).getAnnotation(annotationClass);
                    if (annotation == null) continue;
                    if (!initialized) {
                        resource = supplier.apply(annotation);
                        if (resource == null) {
                            return null;
                        }
                        initialized = true;
                    }
                    ((Field)accessibleObject).setAccessible(true);
                    ((Field)accessibleObject).set(target, resource);
                }
            }
            for (AccessibleObject accessibleObject : target.getClass().getMethods()) {
                if (((Method)accessibleObject).getParameterCount() != 1 || (annotation = ((Method)accessibleObject).getAnnotation(annotationClass)) == null) continue;
                if (!initialized) {
                    resource = supplier.apply(annotation);
                    if (resource == null) {
                        return null;
                    }
                    initialized = true;
                }
                ((Method)accessibleObject).invoke(target, resource);
            }
            return resource;
        }
        return null;
    }

    public void beforeServiceMethodAdvice(ServiceMethodAdvice serviceMethodAdvice, Method interfaceMethod, Object[] args, Object result, Exception lastOccurredException, ServiceInvocationAdviceListener.Instantiator postProcessAdvice) {
        if (this.storeLogDataManager.isEnabled()) {
            this.process(interfaceMethod, args, result, lastOccurredException, postProcessAdvice, e -> e.before() && e.bindToServiceMethodAdvice().equals(serviceMethodAdvice.getClass()));
        }
    }

    public void afterServiceMethodAdvice(ServiceMethodAdvice serviceMethodAdvice, Method interfaceMethod, Object[] args, Object result, Exception lastOccurredException, ServiceInvocationAdviceListener.Instantiator postProcessAdvice) {
        if (this.storeLogDataManager.isEnabled()) {
            this.process(interfaceMethod, args, result, lastOccurredException, postProcessAdvice, e -> !e.before() && e.bindToServiceMethodAdvice().equals(serviceMethodAdvice.getClass()));
        }
    }

    public void beforeMethodInvocation(Method interfaceMethod, Object[] args, Object result, Exception ex, ServiceInvocationAdviceListener.Instantiator postProcessAdvice) {
        if (this.storeLogDataManager.isEnabled()) {
            this.process(interfaceMethod, args, result, ex, postProcessAdvice, e -> e.before() && e.bindToServiceMethodAdvice().equals(PrepareStoreLogData.Default.class));
        }
    }

    public void afterMethodInvocation(Method interfaceMethod, Object[] args, Object result, Exception lastOccurredException, ServiceInvocationAdviceListener.Instantiator postProcessAdvice) {
        if (this.storeLogDataManager.isEnabled()) {
            this.process(interfaceMethod, args, result, lastOccurredException, postProcessAdvice, e -> !e.before() && e.bindToServiceMethodAdvice().equals(PrepareStoreLogData.Default.class));
        }
    }
}

