/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.conf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.common.ProjectException;
import org.openl.rules.project.IRulesDeploySerializer;
import org.openl.rules.project.abstraction.AProject;
import org.openl.rules.project.abstraction.AProjectArtefact;
import org.openl.rules.project.abstraction.AProjectResource;
import org.openl.rules.project.abstraction.Deployment;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.project.xml.XmlRulesDeploySerializer;
import org.openl.rules.ruleservice.conf.DeploymentNameMatcher;
import org.openl.rules.ruleservice.conf.ServiceConfigurer;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.ServiceDescription;
import org.openl.rules.ruleservice.loader.RuleServiceLoader;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastVersionProjectsServiceConfigurer
implements ServiceConfigurer {
    public static final String RULES_DEPLOY_XML = "rules-deploy.xml";
    private final Logger log = LoggerFactory.getLogger(LastVersionProjectsServiceConfigurer.class);
    private IRulesDeploySerializer rulesDeploySerializer = new XmlRulesDeploySerializer();
    private boolean provideRuntimeContext = false;
    private boolean supportVariations = false;
    private String supportedGroups = null;
    private boolean filterDeployments = false;
    private DeploymentNameMatcher deploymentMatcher = DeploymentNameMatcher.DEFAULT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Deployment> filterDeployments(Collection<Deployment> deployments) {
        if (!this.filterDeployments) {
            return deployments;
        }
        HashMap latestDeployments = new HashMap();
        for (Deployment deployment : deployments) {
            if (deployment.getCommonVersion() == null) {
                throw new IllegalArgumentException("Can't detect deployment version. Probably 'version in deployment name' parameter in configuration is incorrect.");
            }
            String deploymentName = deployment.getDeploymentName();
            HashMap<String, Deployment> internalMap = (HashMap<String, Deployment>)latestDeployments.get(deploymentName);
            if (internalMap == null) {
                internalMap = new HashMap<String, Deployment>();
                latestDeployments.put(deploymentName, internalMap);
            }
            boolean hasRulesDeployXML = false;
            for (AProject project : deployment.getProjects()) {
                try {
                    InputStream content = null;
                    try {
                        AProjectArtefact artifact = project.getArtefact(RULES_DEPLOY_XML);
                        if (!(artifact instanceof AProjectResource)) continue;
                        AProjectResource resource = (AProjectResource)artifact;
                        content = resource.getContent();
                        RulesDeploy rulesDeploy = this.getRulesDeploySerializer().deserialize(content);
                        hasRulesDeployXML = true;
                        String version = null;
                        if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getVersion())) {
                            version = rulesDeploy.getVersion();
                        }
                        if (internalMap.containsKey(version)) {
                            if (((Deployment)internalMap.get(version)).getCommonVersion().compareTo((Object)deployment.getCommonVersion()) >= 0) continue;
                            internalMap.put(version, deployment);
                            continue;
                        }
                        internalMap.put(version, deployment);
                    }
                    catch (ProjectException e) {}
                    continue;
                    finally {
                        if (content == null) continue;
                        try {
                            content.close();
                        }
                        catch (IOException e) {
                            this.log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    this.log.error("Failed to load project from repository! Project '{}' in deployment '{}' has been skipped!", new Object[]{project.getName(), deployment.getDeploymentName(), e});
                }
            }
            if (hasRulesDeployXML) continue;
            if (internalMap.containsKey(null)) {
                if (((Deployment)internalMap.get(null)).getCommonVersion().compareTo((Object)deployment.getCommonVersion()) >= 0) continue;
                internalMap.put(null, deployment);
                continue;
            }
            internalMap.put(null, deployment);
        }
        ArrayList<Deployment> ret = new ArrayList<Deployment>();
        for (String key : latestDeployments.keySet()) {
            for (Deployment d : ((Map)latestDeployments.get(key)).values()) {
                ret.add(d);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<ServiceDescription> getServicesToBeDeployed(RuleServiceLoader ruleServiceLoader) {
        this.log.debug("Calculate services to be deployed...");
        Collection<Deployment> allDeployments = ruleServiceLoader.getDeployments();
        Collection<Deployment> deployments = this.filterDeployments(allDeployments);
        HashSet<ServiceDescription> serviceDescriptions = new HashSet<ServiceDescription>();
        HashSet<String> serviceURLs = new HashSet<String>();
        for (Deployment deployment : deployments) {
            if (!this.deploymentMatcher.hasMatches(deployment.getDeploymentName())) continue;
            String deploymentName = deployment.getDeploymentName();
            CommonVersion deploymentVersion = deployment.getCommonVersion();
            DeploymentDescription deploymentDescription = new DeploymentDescription(deploymentName, deploymentVersion);
            for (AProject project : deployment.getProjects()) {
                String projectName = project.getName();
                try {
                    Collection<Module> modulesOfProject = ruleServiceLoader.resolveModulesForProject(deploymentName, deploymentVersion, projectName);
                    ServiceDescription.ServiceDescriptionBuilder serviceDescriptionBuilder = new ServiceDescription.ServiceDescriptionBuilder().setProvideRuntimeContext(this.provideRuntimeContext).setProvideVariations(this.supportVariations).setDeployment(deploymentDescription);
                    serviceDescriptionBuilder.setModules(modulesOfProject);
                    if (modulesOfProject.isEmpty()) continue;
                    InputStream content = null;
                    RulesDeploy rulesDeploy = null;
                    try {
                        AProjectArtefact artifact = project.getArtefact(RULES_DEPLOY_XML);
                        if (artifact instanceof AProjectResource) {
                            AProjectResource resource = (AProjectResource)artifact;
                            content = resource.getContent();
                            rulesDeploy = this.getRulesDeploySerializer().deserialize(content);
                            if (rulesDeploy.getServiceClass() != null && !rulesDeploy.getServiceClass().trim().isEmpty()) {
                                serviceDescriptionBuilder.setServiceClassName(rulesDeploy.getServiceClass().trim());
                            }
                            if (rulesDeploy.getRmiServiceClass() != null && !rulesDeploy.getRmiServiceClass().trim().isEmpty()) {
                                serviceDescriptionBuilder.setRmiServiceClassName(rulesDeploy.getRmiServiceClass().trim());
                            }
                            if (rulesDeploy.isProvideRuntimeContext() != null) {
                                serviceDescriptionBuilder.setProvideRuntimeContext(rulesDeploy.isProvideRuntimeContext());
                            }
                            if (rulesDeploy.isProvideVariations() != null) {
                                serviceDescriptionBuilder.setProvideVariations(rulesDeploy.isProvideVariations());
                            }
                            if (rulesDeploy.getPublishers() != null) {
                                for (RulesDeploy.PublisherType key : rulesDeploy.getPublishers()) {
                                    serviceDescriptionBuilder.addPublisher(key.toString());
                                }
                            }
                            if (rulesDeploy.getConfiguration() != null) {
                                serviceDescriptionBuilder.setConfiguration(rulesDeploy.getConfiguration());
                            }
                            if (rulesDeploy.getInterceptingTemplateClassName() != null && !rulesDeploy.getInterceptingTemplateClassName().trim().isEmpty()) {
                                serviceDescriptionBuilder.setAnnotationTemplateClassName(rulesDeploy.getInterceptingTemplateClassName().trim());
                            }
                            if (rulesDeploy.getAnnotationTemplateClassName() != null && !rulesDeploy.getAnnotationTemplateClassName().trim().isEmpty()) {
                                serviceDescriptionBuilder.setAnnotationTemplateClassName(rulesDeploy.getAnnotationTemplateClassName().trim());
                            }
                        }
                    }
                    catch (ProjectException e) {
                    }
                    finally {
                        if (content != null) {
                            try {
                                content.close();
                            }
                            catch (IOException e) {
                                this.log.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    serviceDescriptionBuilder.setName(this.buildServiceName(deployment, projectName, rulesDeploy));
                    serviceDescriptionBuilder.setUrl(this.buildServiceUrl(deployment, projectName, rulesDeploy));
                    ServiceDescription serviceDescription = serviceDescriptionBuilder.build();
                    if (!serviceDescriptions.contains(serviceDescription) && !serviceURLs.contains(serviceDescription.getUrl()) && this.serviceGroupSupported(rulesDeploy)) {
                        serviceURLs.add(serviceDescription.getUrl());
                        serviceDescriptions.add(serviceDescription);
                        continue;
                    }
                    if (serviceDescriptions.contains(serviceDescription)) {
                        this.log.warn("Service '{}' already exists in the deployment list. The second service has been skipped. Please, use unique name for services.", (Object)serviceDescription.getName());
                    }
                    if (!serviceURLs.contains(serviceDescription.getUrl())) continue;
                    this.log.warn("URL '{}' has already been registered. The second service has been skipped. Please, use unique URLs for services.", (Object)serviceDescription.getUrl());
                }
                catch (Exception e) {
                    this.log.error("Failed to load project from repository! Project '{}' in deployment '{}' has been skipped!", new Object[]{projectName, deploymentName, e});
                }
            }
        }
        return serviceDescriptions;
    }

    private Set<String> getSupportedGroupsSet() {
        if (this.getSupportedGroups() != null && !this.getSupportedGroups().trim().isEmpty()) {
            String[] groups = this.getSupportedGroups().split(",");
            HashSet<String> supportedGroupSet = new HashSet<String>();
            for (String group : groups) {
                supportedGroupSet.add(group.trim());
            }
            return supportedGroupSet;
        }
        return Collections.emptySet();
    }

    private boolean serviceGroupSupported(RulesDeploy rulesDeploy) {
        Set<String> supportedGroupSet = this.getSupportedGroupsSet();
        if (!supportedGroupSet.isEmpty()) {
            String[] groups;
            if (rulesDeploy == null || rulesDeploy.getGroups() == null || rulesDeploy.getGroups().trim().isEmpty()) {
                return false;
            }
            for (String group : groups = rulesDeploy.getGroups().split(",")) {
                if (!supportedGroupSet.contains(group)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String buildServiceName(Deployment deployment, String projectName, RulesDeploy rulesDeploy) {
        if (rulesDeploy != null) {
            if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getServiceName())) {
                if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getVersion())) {
                    return rulesDeploy.getServiceName() + "(version=" + rulesDeploy.getVersion() + ")";
                }
                return rulesDeploy.getServiceName();
            }
            if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getVersion())) {
                return deployment.getDeploymentName() + '_' + projectName + "(version=" + rulesDeploy.getVersion() + ")";
            }
        }
        return deployment.getDeploymentName() + '_' + projectName;
    }

    private String buildServiceUrl(Deployment deployment, String projectName, RulesDeploy rulesDeploy) {
        if (rulesDeploy != null) {
            if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getUrl())) {
                if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getVersion())) {
                    if (rulesDeploy.getUrl().startsWith("/")) {
                        return "/" + rulesDeploy.getVersion() + rulesDeploy.getUrl();
                    }
                    return "/" + rulesDeploy.getVersion() + "/" + rulesDeploy.getUrl();
                }
                return rulesDeploy.getUrl();
            }
            if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getVersion())) {
                return "/" + rulesDeploy.getVersion() + "/" + deployment.getDeploymentName() + '/' + projectName;
            }
        }
        return deployment.getDeploymentName() + '/' + projectName;
    }

    public final IRulesDeploySerializer getRulesDeploySerializer() {
        return this.rulesDeploySerializer;
    }

    public final void setRulesDeploySerializer(IRulesDeploySerializer rulesDeploySerializer) {
        if (rulesDeploySerializer == null) {
            throw new IllegalArgumentException("rulesDeploySerializer arg must not be null.");
        }
        this.rulesDeploySerializer = rulesDeploySerializer;
    }

    public boolean isProvideRuntimeContext() {
        return this.provideRuntimeContext;
    }

    public void setProvideRuntimeContext(boolean provideRuntimeContext) {
        this.provideRuntimeContext = provideRuntimeContext;
    }

    public boolean isSupportVariations() {
        return this.supportVariations;
    }

    public void setSupportVariations(boolean supportVariations) {
        this.supportVariations = supportVariations;
    }

    public void setSupportedGroups(String supportedGroups) {
        this.supportedGroups = supportedGroups;
    }

    public String getSupportedGroups() {
        return this.supportedGroups;
    }

    public void setFilterDeployments(boolean filterDeployments) {
        this.filterDeployments = filterDeployments;
    }

    public void setDatasourceDeploymentPatterns(String deploymentPatterns) {
        this.deploymentMatcher = new DeploymentNameMatcher(deploymentPatterns);
    }
}

