/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.conf;

import java.util.Collection;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class LazyInitBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private Collection<String> lazyBeanNames;

    public Collection<String> getLazyBeanNames() {
        return this.lazyBeanNames;
    }

    public void setLazyBeanNames(Collection<String> lazyBeanNames) {
        this.lazyBeanNames = lazyBeanNames;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            if (!this.lazyBeanNames.contains(beanName)) continue;
            beanFactory.getBeanDefinition(beanName).setLazyInit(true);
        }
    }
}

