/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.openl.CompiledOpenClass;
import org.openl.dependency.IDependencyManager;
import org.openl.rules.project.dependencies.ProjectExternalDependenciesHelper;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RuntimeContextInstantiationStrategyEnhancer;
import org.openl.rules.project.instantiation.variation.VariationInstantiationStrategyEnhancer;
import org.openl.rules.project.model.Module;
import org.openl.rules.ruleservice.core.AbstractOpenLServiceInitializer;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceDeploymentRelatedDependencyManager;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationException;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationFactory;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationFactoryHelper;
import org.openl.rules.ruleservice.core.RuleServiceRuntimeException;
import org.openl.rules.ruleservice.core.ServiceDescription;
import org.openl.rules.ruleservice.core.interceptors.DynamicInterfaceAnnotationEnhancerHelper;
import org.openl.rules.ruleservice.core.interceptors.ServiceInvocationAdvice;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallInterceptorGroup;
import org.openl.rules.ruleservice.loader.RuleServiceLoader;
import org.openl.rules.ruleservice.publish.RuleServiceInstantiationStrategyFactory;
import org.openl.rules.ruleservice.publish.RuleServiceInstantiationStrategyFactoryImpl;
import org.openl.rules.ruleservice.publish.lazy.CompiledOpenClassCache;
import org.openl.runtime.IEngineWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;

public class RuleServiceOpenLServiceInstantiationFactoryImpl
implements RuleServiceInstantiationFactory {
    private final Logger log = LoggerFactory.getLogger(RuleServiceOpenLServiceInstantiationFactoryImpl.class);
    private RuleServiceLoader ruleServiceLoader;
    private RuleServiceInstantiationStrategyFactory instantiationStrategyFactory = new RuleServiceInstantiationStrategyFactoryImpl();
    private Map<String, Object> externalParameters;
    private ServiceCallInterceptorGroup[] serviceCallInterceptorGroups = new ServiceCallInterceptorGroup[0];
    private Map<DeploymentDescription, RuleServiceDeploymentRelatedDependencyManager> dependencyManagerMap = new HashMap<DeploymentDescription, RuleServiceDeploymentRelatedDependencyManager>();

    private void initService(ServiceDescription serviceDescription, RuleServiceDeploymentRelatedDependencyManager dependencyManager, OpenLService service) throws RuleServiceInstantiationException, RulesInstantiationException, ClassNotFoundException {
        RulesInstantiationStrategy instantiationStrategy = this.instantiationStrategyFactory.getStrategy(serviceDescription, (IDependencyManager)dependencyManager);
        Map parameters = ProjectExternalDependenciesHelper.getExternalParamsWithProjectDependencies(this.externalParameters, service.getModules());
        instantiationStrategy.setExternalParameters(parameters);
        if (service.isProvideVariations()) {
            instantiationStrategy = new VariationInstantiationStrategyEnhancer(instantiationStrategy);
        }
        if (service.isProvideRuntimeContext()) {
            instantiationStrategy = new RuntimeContextInstantiationStrategyEnhancer(instantiationStrategy);
        }
        this.resolveInterfaceAndClassLoader(serviceDescription, service, instantiationStrategy);
        this.resolveRmiInterface(service);
        this.instantiateServiceBean(service, instantiationStrategy);
    }

    private void instantiateServiceBean(OpenLService service, RulesInstantiationStrategy instantiationStrategy) throws RuleServiceInstantiationException, RulesInstantiationException, ClassNotFoundException {
        Class<?> serviceClass = service.getServiceClass();
        CompiledOpenClass compiledOpenClass = instantiationStrategy.compile();
        service.setOpenClass(compiledOpenClass.getOpenClass());
        Object serviceBean = instantiationStrategy.instantiate();
        ProxyFactory factory = new ProxyFactory();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(instantiationStrategy.getClassLoader());
            factory.addAdvice((Advice)new ServiceInvocationAdvice(serviceBean, serviceClass, this.getServiceCallInterceptorGroups(), instantiationStrategy.getClassLoader()));
            if (serviceClass.isInterface()) {
                factory.addInterface(serviceClass);
                if (!service.isProvideRuntimeContext()) {
                    factory.addInterface(IEngineWrapper.class);
                }
            } else {
                factory.setTarget(serviceBean);
                factory.setProxyTargetClass(!Proxy.isProxyClass(serviceBean.getClass()));
            }
            Object proxyServiceBean = factory.getProxy();
            service.setServiceBean(proxyServiceBean);
        }
        catch (Exception t) {
            throw new RuleServiceRuntimeException("Failed to create a proxy of service bean object.", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void resolveInterfaceAndClassLoader(ServiceDescription serviceDescription, OpenLService service, RulesInstantiationStrategy instantiationStrategy) throws RuleServiceInstantiationException, RulesInstantiationException, ClassNotFoundException {
        String serviceClassName = service.getServiceClassName();
        Class<?> serviceClass = null;
        ClassLoader serviceClassLoader = instantiationStrategy.getClassLoader();
        service.setClassLoader(serviceClassLoader);
        if (serviceClassName != null) {
            try {
                serviceClass = serviceClassLoader.loadClass(serviceClassName.trim());
                Class<?> interfaceForInstantiationStrategy = RuleServiceInstantiationFactoryHelper.getInterfaceForInstantiationStrategy(instantiationStrategy, serviceClass);
                instantiationStrategy.setServiceClass(interfaceForInstantiationStrategy);
            }
            catch (ClassNotFoundException e) {
                this.log.error("Failed to load service class '{}'.", (Object)serviceClassName, (Object)e);
            }
            catch (NoClassDefFoundError e) {
                this.log.error("Failed to load service class '{}'.", (Object)serviceClassName, (Object)e);
            }
        }
        if (serviceClass == null) {
            this.log.info("Service class is undefined for service '{}'. Generated interface has been used.", (Object)service.getName());
            Class instanceClass = instantiationStrategy.getInstanceClass();
            serviceClass = this.processGeneratedServiceClass(instantiationStrategy, serviceDescription, service, instanceClass, serviceClassLoader);
            service.setServiceClassName(null);
        }
        service.setServiceClass(serviceClass);
    }

    private void resolveRmiInterface(OpenLService service) throws RuleServiceInstantiationException, ClassNotFoundException {
        String rmiServiceClassName = service.getRmiServiceClassName();
        Class<?> serviceClass = null;
        ClassLoader serviceClassLoader = service.getClassLoader();
        if (rmiServiceClassName != null) {
            try {
                serviceClass = serviceClassLoader.loadClass(rmiServiceClassName.trim());
            }
            catch (ClassNotFoundException e) {
                this.log.error("Failed to load rmi service class '{}'", (Object)rmiServiceClassName, (Object)e);
            }
            catch (NoClassDefFoundError e) {
                this.log.error("Failed to load rmi service class '{}'", (Object)rmiServiceClassName, (Object)e);
            }
        }
        if (serviceClass == null) {
            this.log.info("Service class is undefined for service '{}'. Default RMI interface has been used.", (Object)service.getName());
            service.setRmiServiceClassName(null);
        }
        service.setRmiServiceClass(serviceClass);
    }

    private Class<?> processGeneratedServiceClass(RulesInstantiationStrategy instantiationStrategy, ServiceDescription serviceDescription, OpenLService service, Class<?> serviceClass, ClassLoader classLoader) {
        Class<?> resultClass = this.processInterceptingTemplateClassConfiguration(serviceDescription, serviceClass, classLoader);
        if (resultClass == null) {
            throw new IllegalStateException("It must not happen!");
        }
        try {
            Class<?> interfaceForService = RuleServiceInstantiationFactoryHelper.getInterfaceForService(instantiationStrategy, resultClass);
            return interfaceForService;
        }
        catch (Exception e) {
            this.log.error("Failed to applying intercepting template class for '{}'.", (Object)resultClass.getCanonicalName(), (Object)e);
            return resultClass;
        }
    }

    private Class<?> processInterceptingTemplateClassConfiguration(ServiceDescription serviceDescription, Class<?> serviceClass, ClassLoader classLoader) {
        String clazzName = serviceDescription.getAnnotationTemplateClassName();
        if (clazzName != null) {
            try {
                Class<?> interceptingTemplateClass = classLoader.loadClass(clazzName.trim());
                if (interceptingTemplateClass.isInterface()) {
                    Class<?> decoratedClass = DynamicInterfaceAnnotationEnhancerHelper.decorate(serviceClass, interceptingTemplateClass, classLoader);
                    this.log.info("Interceptor template class '{}' has been used for service: {}.", (Object)clazzName, (Object)serviceDescription.getName());
                    return decoratedClass;
                }
                this.log.error("Interface is required! Intercepting template class hasn't been used! Failed to load or apply intercepting template class '{}'.", (Object)clazzName);
            }
            catch (Exception e) {
                this.log.error("Intercepting template class hasn't been used! Failed to load or apply intercepting template class '{}'.", (Object)clazzName, (Object)e);
            }
            catch (NoClassDefFoundError e) {
                this.log.error("Intercepting template class hasn't been used! Failed to load or apply intercepting template class '{}'.", (Object)clazzName, (Object)e);
            }
        }
        return serviceClass;
    }

    @Override
    public OpenLService createService(final ServiceDescription serviceDescription) {
        this.log.debug("Resoliving modules for service '{}'.", (Object)serviceDescription.getName());
        Collection<Module> modules = serviceDescription.getModules();
        OpenLService.OpenLServiceBuilder builder = new OpenLService.OpenLServiceBuilder();
        builder.setName(serviceDescription.getName()).setUrl(serviceDescription.getUrl()).setServiceClassName(serviceDescription.getServiceClassName()).setRmiServiceClassName(serviceDescription.getRmiServiceClassName()).setProvideRuntimeContext(serviceDescription.isProvideRuntimeContext()).setProvideVariations(serviceDescription.isProvideVariations()).addModules(modules);
        if (serviceDescription.getPublishers() != null) {
            for (String key : serviceDescription.getPublishers()) {
                builder.addPublisher(key);
            }
        }
        OpenLService openLService = builder.build(new AbstractOpenLServiceInitializer(){

            @Override
            public void init(OpenLService openLService) throws RuleServiceInstantiationException {
                try {
                    RuleServiceOpenLServiceInstantiationFactoryImpl.this.initService(serviceDescription, RuleServiceOpenLServiceInstantiationFactoryImpl.this.getDependencyManager(serviceDescription), openLService);
                }
                catch (RuleServiceInstantiationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuleServiceInstantiationException(String.format("Failed to initialiaze OpenL service '%s'.", openLService.getName()), e);
                }
            }
        });
        return openLService;
    }

    public RuleServiceLoader getRuleServiceLoader() {
        return this.ruleServiceLoader;
    }

    public void setRuleServiceLoader(RuleServiceLoader ruleServiceLoader) {
        if (ruleServiceLoader == null) {
            throw new IllegalArgumentException("rulesLoader arg must not be null.");
        }
        this.ruleServiceLoader = ruleServiceLoader;
    }

    public RuleServiceInstantiationStrategyFactory getInstantiationStrategyFactory() {
        return this.instantiationStrategyFactory;
    }

    public void setInstantiationStrategyFactory(RuleServiceInstantiationStrategyFactory instantiationStrategyFactory) {
        if (instantiationStrategyFactory == null) {
            throw new IllegalArgumentException("instantiationStrategyFactory arg must not be null.");
        }
        this.instantiationStrategyFactory = instantiationStrategyFactory;
    }

    public Map<String, Object> getExternalParameters() {
        return this.externalParameters;
    }

    public void setExternalParameters(Map<String, Object> externalParameters) {
        this.externalParameters = externalParameters;
    }

    public void clear(DeploymentDescription deploymentDescription) {
        this.dependencyManagerMap.remove(deploymentDescription);
        CompiledOpenClassCache.getInstance().removeAll(deploymentDescription);
    }

    private RuleServiceDeploymentRelatedDependencyManager getDependencyManager(ServiceDescription serviceDescription) {
        RuleServiceDeploymentRelatedDependencyManager dependencyManager;
        DeploymentDescription deployment = serviceDescription.getDeployment();
        if (this.dependencyManagerMap.containsKey(deployment)) {
            dependencyManager = this.dependencyManagerMap.get(deployment);
        } else {
            boolean isLazy = false;
            if (this.instantiationStrategyFactory instanceof RuleServiceInstantiationStrategyFactoryImpl) {
                isLazy = ((RuleServiceInstantiationStrategyFactoryImpl)this.instantiationStrategyFactory).isLazy();
            }
            ClassLoader rootClassLoader = RuleServiceOpenLServiceInstantiationFactoryImpl.class.getClassLoader();
            dependencyManager = new RuleServiceDeploymentRelatedDependencyManager(deployment, this.ruleServiceLoader, rootClassLoader, isLazy);
            dependencyManager.setExternalParameters(this.externalParameters);
            this.dependencyManagerMap.put(deployment, dependencyManager);
        }
        return dependencyManager;
    }

    public ServiceCallInterceptorGroup[] getServiceCallInterceptorGroups() {
        return this.serviceCallInterceptorGroups;
    }

    public void setServiceCallInterceptorGroups(ServiceCallInterceptorGroup[] serviceCallInterceptorGroups) {
        this.serviceCallInterceptorGroups = serviceCallInterceptorGroups;
    }
}

