/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core.interceptors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openl.rules.ruleservice.core.RuleServiceRuntimeException;
import org.openl.rules.ruleservice.core.annotations.ServiceExtraMethod;
import org.openl.rules.ruleservice.core.interceptors.AnyType;
import org.openl.util.ClassUtils;
import org.openl.util.generation.InterfaceTransformer;

public final class DynamicInterfaceAnnotationEnhancerHelper {
    private DynamicInterfaceAnnotationEnhancerHelper() {
    }

    private static void processServiceExtraMethods(ClassVisitor classVisitor, Class<?> templateClass) {
        for (Method method : templateClass.getMethods()) {
            if (!method.isAnnotationPresent(ServiceExtraMethod.class)) continue;
            MethodVisitor methodVisitor = classVisitor.visitMethod(1025, method.getName(), Type.getMethodDescriptor((Method)method), null, null);
        }
    }

    public static Class<?> decorate(Class<?> originalClass, Class<?> templateClass, ClassLoader classLoader) throws Exception {
        if (!templateClass.isInterface()) {
            throw new RuleServiceRuntimeException("Interface is expected!");
        }
        ClassWriter cw = new ClassWriter(0);
        DynamicInterfaceAnnotationEnhancerClassVisitor dynamicInterfaceAnnotationEnhancerClassVisitor = new DynamicInterfaceAnnotationEnhancerClassVisitor((ClassVisitor)cw, templateClass);
        DynamicInterfaceAnnotationEnhancerHelper.processServiceExtraMethods(dynamicInterfaceAnnotationEnhancerClassVisitor, templateClass);
        String enchancedClassName = originalClass.getCanonicalName() + "$Intercepted";
        InterfaceTransformer transformer = new InterfaceTransformer(originalClass, enchancedClassName);
        transformer.accept((ClassVisitor)dynamicInterfaceAnnotationEnhancerClassVisitor);
        cw.visitEnd();
        return ClassUtils.defineClass((String)enchancedClassName, (byte[])cw.toByteArray(), (ClassLoader)classLoader);
    }

    public static Class<?> decorate(Class<?> originalClass, Class<?> templateClass) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return DynamicInterfaceAnnotationEnhancerHelper.decorate(originalClass, templateClass, classLoader);
    }

    private static class DynamicInterfaceAnnotationEnhancerClassVisitor
    extends ClassVisitor {
        private static final String DECORATED_CLASS_NAME_SUFFIX = "$Intercepted";
        private Class<?> templateClass;

        public DynamicInterfaceAnnotationEnhancerClassVisitor(ClassVisitor arg0, Class<?> templateClass) {
            super(327680, arg0);
            this.templateClass = templateClass;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            Annotation[] annotations;
            super.visit(version, access, name, signature, superName, interfaces);
            for (Annotation annotation : annotations = this.templateClass.getAnnotations()) {
                AnnotationVisitor annotationVisitor = this.visitAnnotation(Type.getDescriptor(annotation.annotationType()), true);
                InterfaceTransformer.processAnnotation((Annotation)annotation, (AnnotationVisitor)annotationVisitor);
            }
        }

        public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
            if (this.templateClass != null) {
                AccessibleObject templateMethod = null;
                for (Method method : this.templateClass.getMethods()) {
                    if (!arg1.equals(method.getName())) continue;
                    Type[] typesInTemplateMethod = Type.getArgumentTypes((Method)method);
                    Type[] typesInCurrentMethod = Type.getArgumentTypes((String)arg2);
                    if (typesInCurrentMethod.length != typesInTemplateMethod.length) continue;
                    boolean isCompatible = true;
                    for (int i = 0; i < typesInCurrentMethod.length; ++i) {
                        if (typesInCurrentMethod[i].equals((Object)typesInTemplateMethod[i])) continue;
                        Annotation[] annotations = method.getParameterAnnotations()[i];
                        boolean isAnyTypeParameter = false;
                        for (Annotation annotation : annotations) {
                            if (!annotation.annotationType().equals(AnyType.class)) continue;
                            AnyType anyTypeAnnotation = (AnyType)annotation;
                            String pattern = anyTypeAnnotation.value();
                            if (pattern == null || pattern.isEmpty()) {
                                isAnyTypeParameter = true;
                                continue;
                            }
                            if (!Pattern.matches(pattern, typesInCurrentMethod[i].getClassName())) continue;
                            isAnyTypeParameter = true;
                        }
                        if (isAnyTypeParameter) continue;
                        isCompatible = false;
                        break;
                    }
                    if (!isCompatible) continue;
                    if (templateMethod == null) {
                        templateMethod = method;
                        continue;
                    }
                    throw new RuleServiceRuntimeException("Template class is wrong. It is a non-obvious choice of method. Please, check the template class!");
                }
                if (templateMethod != null) {
                    Annotation[] annotations;
                    MethodVisitor mv = super.visitMethod(arg0, arg1, arg2, arg3, arg4);
                    for (Annotation annotation : annotations = templateMethod.getAnnotations()) {
                        AnnotationVisitor annotationVisitor = mv.visitAnnotation(Type.getDescriptor(annotation.annotationType()), true);
                        InterfaceTransformer.processAnnotation((Annotation)annotation, (AnnotationVisitor)annotationVisitor);
                    }
                    int i = 0;
                    for (Annotation[] parameterAnnotations : ((Method)templateMethod).getParameterAnnotations()) {
                        if (parameterAnnotations.length > 0) {
                            for (Annotation annotation : parameterAnnotations) {
                                AnnotationVisitor annotationVisitor = mv.visitParameterAnnotation(i, Type.getDescriptor(annotation.annotationType()), true);
                                InterfaceTransformer.processAnnotation((Annotation)annotation, (AnnotationVisitor)annotationVisitor);
                            }
                        }
                        ++i;
                    }
                    return mv;
                }
            }
            return super.visitMethod(arg0, arg1, arg2, arg3, arg4);
        }
    }
}

