/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import org.openl.rules.ruleservice.core.RuleServiceRuntimeException;
import org.openl.rules.ruleservice.deployer.RulesDeployerService;
import org.openl.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;

public class DeployClasspathJarsBean
implements InitializingBean {
    private final Logger log = LoggerFactory.getLogger(DeployClasspathJarsBean.class);
    private boolean enabled = false;
    private RulesDeployerService rulesDeployerService;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRulesDeployerService(RulesDeployerService rulesDeployerService) {
        this.rulesDeployerService = rulesDeployerService;
    }

    private void deployJarForJboss(URL resourceURL) throws Exception {
        URLConnection conn = resourceURL.openConnection();
        Object content = conn.getContent();
        Class<?> clazz = content.getClass();
        if (!"org.jboss.vfs.VirtualFile".equals(clazz.getName())) {
            throw new RuleServiceRuntimeException("Protocol VFS supports only for JBoss VFS. URL content must be org.jboss.vfs.VirtualFile!");
        }
        String urlString = resourceURL.toString();
        urlString = urlString.substring(0, urlString.lastIndexOf(".jar") + 4);
        Object jarFile = new URL(urlString).openConnection().getContent();
        Method getNameMethod = clazz.getMethod("getName", new Class[0]);
        String jarName = (String)getNameMethod.invoke(jarFile, new Object[0]);
        Method getPhysicalFileMethod = clazz.getMethod("getPhysicalFile", new Class[0]);
        File contentsFile = (File)getPhysicalFileMethod.invoke(jarFile, new Object[0]);
        File dir = contentsFile.getParentFile();
        File physicalFile = new File(dir, jarName);
        this.rulesDeployerService.deploy(FileUtils.getBaseName((String)jarName), (InputStream)new FileInputStream(physicalFile), false);
    }

    public void afterPropertiesSet() throws Exception {
        Resource[] resources;
        if (!this.isEnabled()) {
            return;
        }
        PathMatchingResourcePatternResolver prpr = new PathMatchingResourcePatternResolver();
        for (Resource rulesXmlResource : resources = prpr.getResources("classpath*:rules.xml")) {
            File file;
            block7: {
                try {
                    URL resourceURL = rulesXmlResource.getURL();
                    if ("jar".equals(resourceURL.getProtocol()) || "wsjar".equals(resourceURL.getProtocol())) {
                        URL jarUrl = ResourceUtils.extractJarFileURL((URL)resourceURL);
                        file = ResourceUtils.getFile((URL)jarUrl);
                        break block7;
                    }
                    if ("vfs".equals(rulesXmlResource.getURL().getProtocol())) {
                        this.deployJarForJboss(resourceURL);
                        continue;
                    }
                    throw new RuleServiceRuntimeException("Protocol for URL isn't supported! URL: " + resourceURL.toString());
                }
                catch (Exception e) {
                    this.log.error("Failed to load a resource!", (Throwable)e);
                    throw new IOException("Failed to load a resource!", e);
                }
            }
            if (!file.exists()) {
                throw new IOException("File hasn't been found. File: " + file.getAbsolutePath());
            }
            this.rulesDeployerService.deploy(FileUtils.getBaseName((String)file.getName()), (InputStream)new FileInputStream(file), false);
        }
    }
}

