/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.loader;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openl.rules.common.ArtefactPath;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.common.impl.ArtefactPathImpl;
import org.openl.rules.common.impl.CommonVersionImpl;
import org.openl.rules.project.abstraction.Deployment;
import org.openl.rules.project.impl.local.LocalFolderAPI;
import org.openl.rules.repository.api.Repository;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.file.FileSystemRepository;
import org.openl.rules.ruleservice.loader.DataSource;
import org.openl.rules.ruleservice.loader.DataSourceException;
import org.openl.rules.ruleservice.loader.DataSourceListener;
import org.openl.rules.workspace.lw.LocalWorkspace;
import org.openl.rules.workspace.lw.impl.LocalWorkspaceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDataSource
implements DataSource {
    private final Logger log = LoggerFactory.getLogger(FileSystemDataSource.class);
    private static final CommonVersion FILESYSTEM_COMMON_VERSION = new CommonVersionImpl(0, 0, 1);
    private File loadDeploymentsFromDirectory;
    private FileFilter localWorkspaceFolderFilter;
    private FileFilter localWorkspaceFileFilter;
    private boolean supportDeployments = false;
    private boolean supportVersion = false;

    public void setLocalWorkspaceFileFilter(FileFilter localWorkspaceFileFilter) {
        this.localWorkspaceFileFilter = localWorkspaceFileFilter;
    }

    public void setLocalWorkspaceFolderFilter(FileFilter localWorkspaceFolderFilter) {
        this.localWorkspaceFolderFilter = localWorkspaceFolderFilter;
    }

    public void setSupportDeployments(boolean supportDeployments) {
        this.supportDeployments = supportDeployments;
    }

    public void setSupportVersion(boolean supportVersion) {
        this.supportVersion = supportVersion;
    }

    public FileSystemDataSource(File loadDeploymentsFromDirectory) {
        if (loadDeploymentsFromDirectory == null) {
            throw new IllegalArgumentException("loadDeploymentsFromDirectory argument can't be null");
        }
        if (!loadDeploymentsFromDirectory.exists()) {
            if (!loadDeploymentsFromDirectory.mkdirs()) {
                this.log.warn("Failed to create file system data source folder '{}'!", (Object)loadDeploymentsFromDirectory);
            } else {
                this.log.info("File system data source '{}' has been created successfully!", (Object)loadDeploymentsFromDirectory);
            }
        }
        if (!loadDeploymentsFromDirectory.exists() || !loadDeploymentsFromDirectory.isDirectory()) {
            throw new DataSourceException("File system data source folder '" + loadDeploymentsFromDirectory + "' doesn't exist");
        }
        this.loadDeploymentsFromDirectory = loadDeploymentsFromDirectory;
    }

    @Override
    public Deployment getDeployment(String deploymentName, CommonVersion deploymentVersion) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("deploymentName argument must not be null!");
        }
        if (deploymentVersion == null) {
            throw new IllegalArgumentException("deploymentVersion argument must not be null!");
        }
        if (!deploymentVersion.equals(FILESYSTEM_COMMON_VERSION) && !this.supportDeployments) {
            return null;
        }
        File[] listOfDeploymentFolders = this.getDeploymentFolderList();
        String deploymentFolderName = deploymentName;
        if (this.supportVersion && this.supportDeployments) {
            deploymentFolderName = deploymentName + "_v" + deploymentVersion.getVersionName();
        }
        for (File deploymentFolder : listOfDeploymentFolders) {
            if (!deploymentFolder.getName().equals(deploymentFolderName)) continue;
            return this.getDeployment(deploymentFolder, deploymentName, deploymentVersion);
        }
        return null;
    }

    private File[] getDeploymentFolderList() {
        File folder = this.loadDeploymentsFromDirectory;
        File[] listOfFiles = !this.supportDeployments ? new File[]{folder} : folder.listFiles(File::isDirectory);
        return listOfFiles;
    }

    @Override
    public Collection<Deployment> getDeployments() {
        File[] listOfDeploymentFolders;
        ArrayList<Deployment> deployments = new ArrayList<Deployment>();
        for (File deploymentFolder : listOfDeploymentFolders = this.getDeploymentFolderList()) {
            Deployment deployment;
            String deploymentName = deploymentFolder.getName();
            CommonVersion commonVersion = FILESYSTEM_COMMON_VERSION;
            if (this.supportVersion && this.supportDeployments) {
                String folderName = deploymentFolder.getName();
                try {
                    int index = folderName.lastIndexOf("_v");
                    String versionSuffix = folderName.substring(index + 2);
                    deploymentName = folderName.substring(0, index);
                    commonVersion = new CommonVersionImpl(versionSuffix);
                }
                catch (Exception e) {
                    this.log.error("Deployment has been skiped! Deployment folder '{}' in file system data source '{}' has invalid version suffix.", (Object)folderName, (Object)this.loadDeploymentsFromDirectory);
                    continue;
                }
            }
            if ((deployment = this.getDeployment(deploymentFolder, deploymentName, commonVersion)).getProjects().isEmpty()) {
                this.log.warn("Deployment of the file system data source '{}' does not contain projects. Make sure that you have specified correct folder!", (Object)deploymentFolder);
            }
            deployments.add(deployment);
        }
        return Collections.unmodifiableCollection(deployments);
    }

    private Deployment getDeployment(File deploymentFolder, String deploymentName, CommonVersion deploymentVersion) {
        LocalFolderAPI localFolderAPI = new LocalFolderAPI(deploymentFolder, (ArtefactPath)new ArtefactPathImpl(deploymentFolder.getName()), (LocalWorkspace)new LocalWorkspaceImpl(null, deploymentFolder.getParentFile(), this.localWorkspaceFolderFilter, this.localWorkspaceFileFilter));
        FileSystemRepository repository = new FileSystemRepository();
        repository.setRoot(deploymentFolder.getParentFile());
        try {
            repository.initialize();
        }
        catch (RRepositoryException e) {
            this.log.error("Failed to initialize local repository: {}", (Object)e.getMessage(), (Object)e);
        }
        String folderPath = localFolderAPI.getArtefactPath().getStringValue();
        boolean folderStructure = !repository.listFolders(folderPath).isEmpty();
        return new Deployment((Repository)repository, folderPath, deploymentName, deploymentVersion, folderStructure);
    }

    @Override
    public void setListener(DataSourceListener dataSourceListener) {
    }
}

