/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.loader;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.common.ProjectException;
import org.openl.rules.project.abstraction.AProjectArtefact;
import org.openl.rules.project.abstraction.Deployment;
import org.openl.rules.repository.api.Repository;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.file.FileSystemRepository;
import org.openl.rules.ruleservice.core.RuleServiceRuntimeException;
import org.openl.rules.workspace.lw.impl.FolderHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTemporaryDeploymentsStorage {
    private final Logger log = LoggerFactory.getLogger(LocalTemporaryDeploymentsStorage.class);
    private String directoryToLoadDeploymentsIn;
    private Map<String, Deployment> cacheForGetDeployment = new HashMap<String, Deployment>();
    private Repository repository;

    public LocalTemporaryDeploymentsStorage(String directoryToLoadDeploymentsIn) {
        if (directoryToLoadDeploymentsIn == null) {
            throw new IllegalArgumentException("directoryToLoadDeploymentsIn argument must not be null.");
        }
        this.directoryToLoadDeploymentsIn = directoryToLoadDeploymentsIn;
        File folderToLoadDeploymentsIn = new File(directoryToLoadDeploymentsIn);
        folderToLoadDeploymentsIn.mkdirs();
        if (!FolderHelper.clearFolder((File)folderToLoadDeploymentsIn)) {
            this.log.error("Failed to clear a folder '{}'!", (Object)folderToLoadDeploymentsIn.getAbsolutePath());
        } else {
            this.log.info("Local temporary folder for downloading deployments has been cleared.");
        }
        this.log.info("Local temporary folder location is: {}", (Object)directoryToLoadDeploymentsIn);
        FileSystemRepository localRepository = new FileSystemRepository();
        localRepository.setRoot(folderToLoadDeploymentsIn);
        try {
            localRepository.initialize();
        }
        catch (RRepositoryException e) {
            this.log.error("Failed to initialize local repository: {}", (Object)e.getMessage(), (Object)e);
        }
        this.repository = localRepository;
    }

    public String getDirectoryToLoadDeploymentsIn() {
        return this.directoryToLoadDeploymentsIn;
    }

    private String getDeploymentFolderName(String deploymentName, CommonVersion version) {
        return deploymentName + "_v" + version.getVersionName();
    }

    Deployment getDeployment(String deploymentName, CommonVersion version) {
        this.log.debug("Getting deployment with name='{}' and version='{}'", (Object)deploymentName, (Object)version.getVersionName());
        String deploymentFolderName = this.getDeploymentFolderName(deploymentName, version);
        return this.cacheForGetDeployment.get(deploymentFolderName);
    }

    Deployment loadDeployment(Deployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException("deployment argument must not be null.");
        }
        String deploymentName = deployment.getDeploymentName();
        CommonVersion version = deployment.getCommonVersion();
        String versionName = deployment.getVersion().getVersionName();
        this.log.debug("Loading deployement with name='{}' and version='{}'", (Object)deploymentName, (Object)versionName);
        String deploymentFolderName = this.getDeploymentFolderName(deploymentName, version);
        Deployment loadedDeployment = new Deployment(this.repository, deploymentFolderName, deploymentName, version, true);
        try {
            loadedDeployment.update((AProjectArtefact)deployment, null);
            loadedDeployment.refresh();
        }
        catch (ProjectException e) {
            this.log.warn("Exception occurs on loading deployment with name='{}' and version='{}' from data source.", new Object[]{deploymentName, versionName, e});
            throw new RuleServiceRuntimeException(e);
        }
        this.cacheForGetDeployment.put(deploymentFolderName, loadedDeployment);
        this.log.debug("Deployment with name='{}' and version='{}' has been made on local storage and put to cache.", (Object)deploymentName, (Object)versionName);
        return loadedDeployment;
    }

    boolean containsDeployment(String deploymentName, CommonVersion version) {
        return this.cacheForGetDeployment.containsKey(this.getDeploymentFolderName(deploymentName, version));
    }
}

