/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.loader;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.project.abstraction.AProject;
import org.openl.rules.project.abstraction.Deployment;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.ProjectResolver;
import org.openl.rules.project.resolving.ProjectResolvingException;
import org.openl.rules.ruleservice.core.RuleServiceRuntimeException;
import org.openl.rules.ruleservice.loader.DataSource;
import org.openl.rules.ruleservice.loader.DataSourceListener;
import org.openl.rules.ruleservice.loader.LocalTemporaryDeploymentsStorage;
import org.openl.rules.ruleservice.loader.RuleServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleServiceLoaderImpl
implements RuleServiceLoader {
    private final Logger log = LoggerFactory.getLogger(RuleServiceLoaderImpl.class);
    private DataSource dataSource;
    private ProjectResolver projectResolver;
    private LocalTemporaryDeploymentsStorage storage;

    public RuleServiceLoaderImpl() {
    }

    public RuleServiceLoaderImpl(DataSource dataSource, LocalTemporaryDeploymentsStorage storage, ProjectResolver projectResolver) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource argument must not be null!");
        }
        if (storage == null) {
            throw new IllegalArgumentException("storage argument must not be null!");
        }
        if (projectResolver == null) {
            throw new IllegalArgumentException("projectResolver argument must not be null!");
        }
        this.dataSource = dataSource;
        this.storage = storage;
        this.projectResolver = projectResolver;
    }

    @Override
    public void setListener(DataSourceListener dataSourceListener) {
        this.dataSource.setListener(dataSourceListener);
    }

    public void setDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource argument must not be null!");
        }
        this.dataSource = dataSource;
    }

    public ProjectResolver getProjectResolver() {
        return this.projectResolver;
    }

    public void setProjectResolver(ProjectResolver projectResolver) {
        if (projectResolver == null) {
            throw new IllegalArgumentException("projectResolver argument must not be null!");
        }
        this.projectResolver = projectResolver;
    }

    public LocalTemporaryDeploymentsStorage getStorage() {
        return this.storage;
    }

    public void setStorage(LocalTemporaryDeploymentsStorage storage) {
        if (storage == null) {
            throw new IllegalArgumentException("storage argument must not be null!");
        }
        this.storage = storage;
    }

    @Override
    public Collection<Deployment> getDeployments() {
        return this.dataSource.getDeployments();
    }

    @Override
    public Collection<Module> resolveModulesForProject(String deploymentName, CommonVersion deploymentVersion, String projectName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("deploymentName argument must not be null!");
        }
        if (deploymentVersion == null) {
            throw new IllegalArgumentException("deploymentVersion argument must not be null!");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("projectName argument must not be null!");
        }
        this.log.debug("Resoliving modules for deployment (name='{}', version='{}', projectName='{}')", new Object[]{deploymentName, deploymentVersion.getVersionName(), projectName});
        Deployment localDeployment = this.getDeploymentFromStorage(deploymentName, deploymentVersion);
        AProject project = localDeployment.getProject(projectName);
        if (project == null) {
            throw new RuleServiceRuntimeException("Deployment '" + deploymentName + "' doesn't contain a project '" + projectName + "'!");
        }
        String artefactPath = this.storage.getDirectoryToLoadDeploymentsIn() + project.getArtefactPath().getStringValue();
        File projectFolder = new File(artefactPath);
        List<Object> result = Collections.emptyList();
        try {
            ProjectDescriptor projectDescriptor = this.projectResolver.resolve(projectFolder);
            if (projectDescriptor != null) {
                List modules = projectDescriptor.getModules();
                result = Collections.unmodifiableList(modules);
            }
        }
        catch (ProjectResolvingException e) {
            this.log.error("Project resolving has been failed!", (Throwable)e);
        }
        return result;
    }

    private Deployment getDeploymentFromStorage(String deploymentName, CommonVersion commonVersion) {
        Deployment localDeployment = this.storage.getDeployment(deploymentName, commonVersion);
        if (localDeployment == null) {
            Deployment deployment = this.dataSource.getDeployment(deploymentName, commonVersion);
            localDeployment = this.storage.loadDeployment(deployment);
        }
        return localDeployment;
    }
}

