/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceDeployException;
import org.openl.rules.ruleservice.core.RuleServiceImpl;
import org.openl.rules.ruleservice.core.RuleServiceUndeployException;
import org.openl.rules.ruleservice.publish.AbstractRuleServicePublisher;
import org.openl.rules.ruleservice.publish.RuleServicePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;

public class MultipleRuleServicePublisher
extends AbstractRuleServicePublisher
implements InitializingBean {
    private final Logger log = LoggerFactory.getLogger(RuleServiceImpl.class);
    private Map<String, RuleServicePublisher> supportedPublishers = new TreeMap<String, RuleServicePublisher>((o1, o2) -> o1.toUpperCase().compareTo(o2.toUpperCase()));
    private Collection<RuleServicePublisher> defaultRuleServicePublishers;
    private Map<String, OpenLService> services = new HashMap<String, OpenLService>();

    public Map<String, RuleServicePublisher> getSupportedPublishers() {
        return this.supportedPublishers;
    }

    public void setSupportedPublishers(Map<String, RuleServicePublisher> supportedPublishers) {
        this.supportedPublishers = new TreeMap<String, RuleServicePublisher>((o1, o2) -> o1.toUpperCase().compareTo(o2.toUpperCase()));
        this.supportedPublishers.putAll(supportedPublishers);
    }

    protected Collection<RuleServicePublisher> dispatch(OpenLService service) {
        ArrayList<RuleServicePublisher> publishers = new ArrayList<RuleServicePublisher>();
        if (service.getPublishers() == null || service.getPublishers().isEmpty()) {
            publishers.addAll(this.getDefaultRuleServicePublishers());
            return publishers;
        }
        if (this.getSupportedPublishers() != null) {
            for (String key : service.getPublishers()) {
                RuleServicePublisher publisher = this.supportedPublishers.get(key);
                if (this.supportedPublishers.get(key) == null) continue;
                publishers.add(publisher);
            }
            if (publishers.isEmpty()) {
                publishers.addAll(this.getDefaultRuleServicePublishers());
            }
        }
        return publishers;
    }

    public Collection<RuleServicePublisher> getDefaultRuleServicePublishers() {
        return this.defaultRuleServicePublishers;
    }

    public void setDefaultRuleServicePublishers(Collection<RuleServicePublisher> defaultRuleServicePublishers) {
        this.defaultRuleServicePublishers = defaultRuleServicePublishers;
    }

    @Override
    protected void deployService(OpenLService service) throws RuleServiceDeployException {
        Collection<RuleServicePublisher> publishers = this.dispatch(service);
        RuleServiceDeployException e1 = null;
        for (RuleServicePublisher publisher : publishers) {
            if (publisher.isServiceDeployed(service.getName())) continue;
            try {
                publisher.deploy(service);
            }
            catch (RuleServiceDeployException e) {
                e1 = e;
            }
        }
        if (e1 != null) {
            for (RuleServicePublisher publisher : publishers) {
                if (!publisher.isServiceDeployed(service.getName())) continue;
                try {
                    publisher.undeploy(service.getName());
                }
                catch (RuleServiceUndeployException e) {
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error("Failed to undeploy service '{}' with URL '{}'!", (Object)service.getName(), (Object)service.getUrl());
                }
            }
            throw new RuleServiceDeployException("Failed to deploy service!", e1);
        }
        this.services.put(service.getName(), service);
    }

    @Override
    public OpenLService getServiceByName(String serviceName) {
        return this.services.get(serviceName);
    }

    @Override
    public Collection<OpenLService> getServices() {
        return new ArrayList<OpenLService>(this.services.values());
    }

    @Override
    public void undeployService(String serviceName) throws RuleServiceUndeployException {
        OpenLService service = this.services.get(serviceName);
        Collection<RuleServicePublisher> publishers = this.dispatch(service);
        RuleServiceUndeployException e1 = null;
        for (RuleServicePublisher publisher : publishers) {
            if (!publisher.isServiceDeployed(serviceName)) continue;
            try {
                publisher.undeploy(serviceName);
            }
            catch (RuleServiceUndeployException e) {
                e1 = e;
            }
        }
        if (e1 != null) {
            throw new RuleServiceUndeployException("Failed to undeploy service!", e1);
        }
        this.services.remove(serviceName);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getDefaultRuleServicePublishers() == null || this.getDefaultRuleServicePublishers().isEmpty()) {
            throw new BeanInitializationException("You must define at least one default publisher!");
        }
    }

    @Override
    public boolean isServiceDeployed(String name) {
        return this.getServiceByName(name) != null;
    }
}

