/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.lazy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openl.IOpenBinder;
import org.openl.conf.IUserContext;
import org.openl.rules.lang.xls.prebind.IPrebindHandler;
import org.openl.rules.lang.xls.prebind.XlsPreBinder;

public class LazyBinderInvocationHandler
implements InvocationHandler {
    private static final ThreadLocal<IPrebindHandler> prebindHandlerHolder = new ThreadLocal();
    private final IOpenBinder originalBinder;
    private final IUserContext ucxt;

    public static void setPrebindHandler(IPrebindHandler prebindHandler) {
        prebindHandlerHolder.set(prebindHandler);
    }

    public static void removePrebindHandler() {
        prebindHandlerHolder.remove();
    }

    public static IPrebindHandler getPrebindHandler() {
        return prebindHandlerHolder.get();
    }

    public LazyBinderInvocationHandler(IOpenBinder originalBinder, IUserContext ucxt) {
        this.originalBinder = originalBinder;
        this.ucxt = ucxt;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        IOpenBinder binder = this.originalBinder;
        IPrebindHandler prebindHandler = prebindHandlerHolder.get();
        if (prebindHandler != null) {
            binder = new XlsPreBinder(this.ucxt, prebindHandler);
        }
        try {
            return method.invoke((Object)binder, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

