/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.lazy;

import java.util.Collection;
import org.openl.CompiledOpenClass;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.message.OpenLMessage;
import org.openl.rules.ruleservice.core.LazyRuleServiceDependencyLoader;
import org.openl.rules.ruleservice.core.RuleServiceDeploymentRelatedDependencyManager;
import org.openl.syntax.code.IDependency;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenClass;

public class LazyCompiledOpenClass
extends CompiledOpenClass {
    private LazyRuleServiceDependencyLoader lazyRuleServiceDependencyLoader;
    private RuleServiceDeploymentRelatedDependencyManager dependencyManager;
    private IDependency dependency;

    public LazyCompiledOpenClass(RuleServiceDeploymentRelatedDependencyManager dependencyManager, LazyRuleServiceDependencyLoader lazyRuleServiceDependencyLoader, IDependency dependency) {
        super(null, null, null, null);
        if (lazyRuleServiceDependencyLoader == null) {
            throw new IllegalArgumentException("lazyRuleServiceDependencyLoader must not be null!");
        }
        if (dependency == null) {
            throw new IllegalArgumentException("dependency must not be null!");
        }
        if (dependencyManager == null) {
            throw new IllegalArgumentException("dependencyManager must not be null!");
        }
        this.dependencyManager = dependencyManager;
        this.lazyRuleServiceDependencyLoader = lazyRuleServiceDependencyLoader;
        this.dependency = dependency;
    }

    protected CompiledOpenClass getCompiledOpenClass() {
        try {
            return this.lazyRuleServiceDependencyLoader.compile(this.dependency.getNode().getIdentifier(), this.dependencyManager);
        }
        catch (OpenLCompilationException e) {
            throw new OpenlNotCheckedException("It must not happen! Compilation validated before!");
        }
    }

    public SyntaxNodeException[] getBindingErrors() {
        return this.getCompiledOpenClass().getBindingErrors();
    }

    public IOpenClass getOpenClass() {
        return this.getCompiledOpenClass().getOpenClass();
    }

    public IOpenClass getOpenClassWithErrors() {
        return this.getCompiledOpenClass().getOpenClassWithErrors();
    }

    public int hashCode() {
        return this.getCompiledOpenClass().hashCode();
    }

    public SyntaxNodeException[] getParsingErrors() {
        return this.getCompiledOpenClass().getParsingErrors();
    }

    public boolean hasErrors() {
        return this.getCompiledOpenClass().hasErrors();
    }

    public void throwErrorExceptionsIfAny() {
        this.getCompiledOpenClass().throwErrorExceptionsIfAny();
    }

    public Collection<OpenLMessage> getMessages() {
        return this.getCompiledOpenClass().getMessages();
    }

    public Collection<IOpenClass> getTypes() {
        return this.getCompiledOpenClass().getTypes();
    }

    public ClassLoader getClassLoader() {
        return this.getCompiledOpenClass().getClassLoader();
    }

    public boolean equals(Object obj) {
        return this.getCompiledOpenClass().equals(obj);
    }

    public String toString() {
        return this.getCompiledOpenClass().toString();
    }
}

