/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.lazy;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.conf.OpenLConfigurator;
import org.openl.dependency.IDependencyManager;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.context.IRulesRuntimeContextProvider;
import org.openl.rules.lang.xls.prebind.IPrebindHandler;
import org.openl.rules.lang.xls.prebind.XlsLazyModuleOpenClass;
import org.openl.rules.project.model.Module;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAfterInterceptor;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAfterInterceptors;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAroundInterceptor;
import org.openl.rules.ruleservice.publish.lazy.LazyBinderInvocationHandler;
import org.openl.rules.ruleservice.publish.lazy.LazyField;
import org.openl.rules.ruleservice.publish.lazy.LazyMethod;
import org.openl.rules.ruleservice.publish.lazy.LazyOpenLConfigurator;
import org.openl.rules.runtime.AOpenLRulesEngineFactory;
import org.openl.rules.runtime.InterfaceClassGenerator;
import org.openl.rules.runtime.InterfaceClassGeneratorImpl;
import org.openl.rules.runtime.RulesEngineFactory;
import org.openl.rules.source.impl.VirtualSourceCodeModule;
import org.openl.runtime.IEngineWrapper;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.code.Dependency;
import org.openl.syntax.code.DependencyType;
import org.openl.syntax.code.IDependency;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyEngineFactory<T>
extends AOpenLRulesEngineFactory {
    private static final String RULES_XLS_OPENL_NAME = "org.openl.xls.sequential";
    private final Logger log = LoggerFactory.getLogger(LazyEngineFactory.class);
    private CompiledOpenClass compiledOpenClass;
    private Class<T> interfaceClass;
    private Collection<Module> modules;
    private IDependencyManager dependencyManager;
    private Map<String, Object> externalParameters;
    private DeploymentDescription deployment;
    private InterfaceClassGenerator interfaceClassGenerator = new InterfaceClassGeneratorImpl();

    public DeploymentDescription getDeployment() {
        return this.deployment;
    }

    public void setInterfaceClassGenerator(InterfaceClassGenerator interfaceClassGenerator) {
        if (interfaceClassGenerator == null) {
            throw new IllegalArgumentException("interfaceClassGenerator argument must not be null!");
        }
        if (this.interfaceClass != null) {
            this.log.warn("Rules engine factory already has interface class. Interface class generator has been ignored!");
        }
        this.interfaceClassGenerator = interfaceClassGenerator;
    }

    public InterfaceClassGenerator getInterfaceClassGenerator() {
        return this.interfaceClassGenerator;
    }

    public LazyEngineFactory(DeploymentDescription deployment, Collection<Module> modules) {
        super(RULES_XLS_OPENL_NAME);
        if (deployment == null) {
            throw new IllegalArgumentException("deployment must not be null!");
        }
        this.deployment = deployment;
        this.modules = modules;
    }

    public LazyEngineFactory(DeploymentDescription deployment, Collection<Module> modules, IDependencyManager dependencyManager) {
        this(deployment, modules);
        this.dependencyManager = dependencyManager;
    }

    public LazyEngineFactory(DeploymentDescription deployment, Collection<Module> modules, IDependencyManager dependencyManager, Map<String, Object> externalParameters) {
        this(deployment, modules, dependencyManager);
        this.externalParameters = externalParameters;
    }

    public LazyEngineFactory(DeploymentDescription deployment, Collection<Module> modules, Class<T> interfaceClass) {
        this(deployment, modules);
        this.interfaceClass = interfaceClass;
    }

    public LazyEngineFactory(DeploymentDescription deployment, Collection<Module> modules, Class<T> interfaceClass, Map<String, Object> externalParameters) {
        this(deployment, modules, interfaceClass);
        this.externalParameters = externalParameters;
    }

    public LazyEngineFactory(DeploymentDescription deployment, Collection<Module> modules, IDependencyManager dependencyManager, Class<T> interfaceClass) {
        this(deployment, modules, dependencyManager);
        this.interfaceClass = interfaceClass;
    }

    public LazyEngineFactory(DeploymentDescription deployment, Collection<Module> modules, IDependencyManager dependencyManager, Class<T> interfaceClass, Map<String, Object> externalParameters) {
        this(deployment, modules, dependencyManager, interfaceClass);
        this.externalParameters = externalParameters;
    }

    public CompiledOpenClass getCompiledOpenClass() {
        if (this.compiledOpenClass == null) {
            this.compiledOpenClass = this.initializeOpenClass();
        }
        return this.compiledOpenClass;
    }

    public Class<T> getInterfaceClass() {
        if (this.interfaceClass == null) {
            CompiledOpenClass compiledOpenClass = this.getCompiledOpenClass();
            IOpenClass openClass = compiledOpenClass.getOpenClass();
            String className = openClass.getName();
            try {
                this.interfaceClass = this.interfaceClassGenerator.generateInterface(className, openClass, this.getCompiledOpenClass().getClassLoader());
            }
            catch (Exception e) {
                String errorMessage = String.format("Failed to create interface: %s", className);
                this.log.error(errorMessage, (Throwable)e);
                throw new OpenlNotCheckedException(errorMessage, (Throwable)e);
            }
        }
        return this.interfaceClass;
    }

    protected Class<?>[] prepareInstanceInterfaces() {
        return new Class[]{this.getInterfaceClass(), IEngineWrapper.class, IRulesRuntimeContextProvider.class};
    }

    protected Object prepareInstance(IRuntimeEnv runtimeEnv) {
        try {
            this.compiledOpenClass = this.getCompiledOpenClass();
            IOpenClass openClass = this.compiledOpenClass.getOpenClass();
            Object openClassInstance = openClass.newInstance(runtimeEnv);
            Map methodMap = this.prepareMethodMap(this.getInterfaceClass(), openClass);
            return this.prepareProxyInstance(openClassInstance, methodMap, runtimeEnv, this.getCompiledOpenClass().getClassLoader());
        }
        catch (Exception ex) {
            String errorMessage = "Failed to instantiate engine instance!";
            throw new OpenlNotCheckedException(errorMessage, (Throwable)ex);
        }
    }

    Module getModuleForMember(IOpenMember member) {
        String sourceUrl = member.getDeclaringClass().getMetaInfo().getSourceUrl();
        Module module = this.getModuleForSourceUrl(sourceUrl, this.modules);
        if (module != null) {
            return module;
        }
        throw new OpenlNotCheckedException("Module is not found");
    }

    private Module getModuleForSourceUrl(String sourceUrl, Collection<Module> modules) {
        if (modules.size() == 1) {
            return modules.iterator().next();
        }
        for (Module module : modules) {
            String modulePath = module.getRulesRootPath().getPath();
            try {
                if (!FilenameUtils.normalize((String)sourceUrl).equals(FilenameUtils.normalize((String)new File(modulePath).getCanonicalFile().toURI().toURL().toExternalForm()))) continue;
                return module;
            }
            catch (Exception e) {
                this.log.warn("Failed to build url for module '{}' with path: {}", new Object[]{module.getName(), modulePath, e});
            }
        }
        return null;
    }

    private LazyMethod makeLazyMethod(XlsLazyModuleOpenClass xlsLazyModuleOpenClass, IOpenMethod method) {
        Module declaringModule = this.getModuleForMember((IOpenMember)method);
        Class[] argTypes = new Class[method.getSignature().getNumberOfParameters()];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = method.getSignature().getParameterType(i).getInstanceClass();
        }
        return LazyMethod.getLazyMethod(xlsLazyModuleOpenClass, this.deployment, declaringModule, argTypes, method, this.dependencyManager, Thread.currentThread().getContextClassLoader(), true, this.externalParameters);
    }

    private LazyField makeLazyField(XlsLazyModuleOpenClass xlsLazyModuleOpenClass, IOpenField field) {
        Module declaringModule = this.getModuleForMember((IOpenMember)field);
        return LazyField.getLazyField(xlsLazyModuleOpenClass, this.deployment, declaringModule, field, this.dependencyManager, Thread.currentThread().getContextClassLoader(), true, this.externalParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompiledOpenClass initializeOpenClass() {
        IPrebindHandler prebindHandler = LazyBinderInvocationHandler.getPrebindHandler();
        try {
            CompiledOpenClass result;
            LazyBinderInvocationHandler.setPrebindHandler(new IPrebindHandler(){

                public IOpenMethod processMethodAdded(IOpenMethod method, XlsLazyModuleOpenClass moduleOpenClass) {
                    return LazyEngineFactory.this.makeLazyMethod(moduleOpenClass, method);
                }

                public IOpenField processFieldAdded(IOpenField field, XlsLazyModuleOpenClass moduleOpenClass) {
                    return LazyEngineFactory.this.makeLazyField(moduleOpenClass, field);
                }
            });
            IOpenSourceCodeModule mainModule = this.createMainModule();
            RulesEngineFactory engineFactory = new RulesEngineFactory(mainModule, ".", this.getOpenlName());
            engineFactory.setDependencyManager(this.dependencyManager);
            engineFactory.setExecutionMode(true);
            CompiledOpenClass compiledOpenClass = result = engineFactory.getCompiledOpenClass();
            return compiledOpenClass;
        }
        finally {
            LazyBinderInvocationHandler.setPrebindHandler(prebindHandler);
        }
    }

    private IOpenSourceCodeModule createMainModule() {
        ArrayList<IDependency> dependencies = new ArrayList<IDependency>();
        for (Module module : this.modules) {
            IDependency dependency = this.createDependency(module);
            dependencies.add(dependency);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.getExternalParameters() != null) {
            params.putAll(this.getExternalParameters());
        }
        if (params.get("external-dependencies") != null) {
            List externalDependencies = (List)params.get("external-dependencies");
            dependencies.addAll(externalDependencies);
        }
        params.put("external-dependencies", dependencies);
        VirtualSourceCodeModule source = new VirtualSourceCodeModule();
        source.setParams(params);
        return source;
    }

    private IDependency createDependency(Module module) {
        return new Dependency(DependencyType.MODULE, new IdentifierNode(null, null, module.getName(), null));
    }

    public Map<String, Object> getExternalParameters() {
        return this.externalParameters;
    }

    public IDependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    protected void validateReturnType(IOpenMethod openMethod, Method interfaceMethod) {
        if (!(interfaceMethod.isAnnotationPresent(ServiceCallAfterInterceptor.class) || interfaceMethod.isAnnotationPresent(ServiceCallAfterInterceptors.class) || interfaceMethod.isAnnotationPresent(ServiceCallAroundInterceptor.class))) {
            super.validateReturnType(openMethod, interfaceMethod);
        }
    }

    static {
        OpenL.setConfig((OpenLConfigurator)new LazyOpenLConfigurator());
    }
}

