/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.lazy;

import java.util.Map;
import org.openl.CompiledOpenClass;
import org.openl.dependency.IDependencyManager;
import org.openl.rules.lang.xls.prebind.XlsLazyModuleOpenClass;
import org.openl.rules.project.model.Module;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.RuleServiceOpenLCompilationException;
import org.openl.rules.ruleservice.publish.lazy.CompiledOpenClassCache;
import org.openl.rules.ruleservice.publish.lazy.LazyMember;
import org.openl.rules.ruleservice.publish.lazy.LazyMemberEvent;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;

public abstract class LazyField
extends LazyMember<IOpenField>
implements IOpenField {
    private String fieldName;

    private LazyField(String fieldName, IOpenField original, IDependencyManager dependencyManager, ClassLoader classLoader, boolean executionMode, Map<String, Object> externalParameters) {
        super(dependencyManager, executionMode, classLoader, original, externalParameters);
        this.fieldName = fieldName;
    }

    public static final LazyField getLazyField(final XlsLazyModuleOpenClass xlsLazyModuleOpenClass, final DeploymentDescription deployment, final Module module, IOpenField original, IDependencyManager dependencyManager, ClassLoader classLoader, boolean executionMode, Map<String, Object> externalParameters) {
        LazyField lazyField = new LazyField(original.getName(), original, dependencyManager, classLoader, executionMode, externalParameters){

            @Override
            public DeploymentDescription getDeployment() {
                return deployment;
            }

            @Override
            public Module getModule() {
                return module;
            }

            @Override
            public XlsLazyModuleOpenClass getXlsLazyModuleOpenClass() {
                return xlsLazyModuleOpenClass;
            }
        };
        CompiledOpenClassCache.getInstance().registerEvent(deployment, module.getName(), new LazyMemberEvent(lazyField));
        return lazyField;
    }

    @Override
    public IOpenField getMember() {
        IOpenField cachedMember = (IOpenField)this.getCachedMember();
        if (cachedMember != null) {
            return cachedMember;
        }
        try {
            CompiledOpenClass compiledOpenClass = this.getCompiledOpenClassWithThrowErrorExceptionsIfAny();
            IOpenField openField = compiledOpenClass.getOpenClass().getField(this.fieldName);
            this.setCachedMember(openField);
            return openField;
        }
        catch (Exception e) {
            throw new RuleServiceOpenLCompilationException("Failed to load lazy field.", e);
        }
    }

    public Object get(Object target, IRuntimeEnv env) {
        return this.getMember().get(target, env);
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        this.getMember().set(target, value, env);
    }

    public boolean isConst() {
        return ((IOpenField)this.getOriginal()).isConst();
    }

    public boolean isReadable() {
        return ((IOpenField)this.getOriginal()).isReadable();
    }

    public boolean isWritable() {
        return ((IOpenField)this.getOriginal()).isWritable();
    }
}

