/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.lazy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.openl.CompiledOpenClass;
import org.openl.dependency.IDependencyManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.lang.xls.prebind.ILazyMember;
import org.openl.rules.lang.xls.prebind.IPrebindHandler;
import org.openl.rules.lang.xls.prebind.XlsLazyModuleOpenClass;
import org.openl.rules.project.dependencies.ProjectExternalDependenciesHelper;
import org.openl.rules.project.instantiation.RulesInstantiationStrategyFactory;
import org.openl.rules.project.instantiation.SingleModuleInstantiationStrategy;
import org.openl.rules.project.model.Module;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.MaxThreadsForCompileSemaphore;
import org.openl.rules.ruleservice.publish.lazy.CompiledOpenClassCache;
import org.openl.rules.ruleservice.publish.lazy.LazyBinderInvocationHandler;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LazyMember<T extends IOpenMember>
implements ILazyMember<T>,
IOpenMember {
    private final Logger log = LoggerFactory.getLogger(LazyMember.class);
    private IDependencyManager dependencyManager;
    private boolean executionMode;
    private T original;
    private Map<String, Object> externalParameters;
    private ClassLoader classLoader;
    private volatile T cachedMember;

    public LazyMember(IDependencyManager dependencyManager, boolean executionMode, ClassLoader classLoader, T original, Map<String, Object> externalParameters) {
        this.dependencyManager = dependencyManager;
        this.executionMode = executionMode;
        this.classLoader = classLoader;
        this.original = original;
        this.externalParameters = externalParameters;
    }

    protected abstract T getMember();

    protected T getCachedMember() {
        return this.cachedMember;
    }

    protected void setCachedMember(T member) {
        this.cachedMember = member;
    }

    public void clearCachedMember() {
        this.cachedMember = null;
    }

    protected CompiledOpenClass getCompiledOpenClassWithThrowErrorExceptionsIfAny() throws Exception {
        CompiledOpenClass compiledOpenClass = this.getCompiledOpenClass();
        if (compiledOpenClass.hasErrors()) {
            compiledOpenClass.throwErrorExceptionsIfAny();
        }
        return compiledOpenClass;
    }

    protected CompiledOpenClass getCompiledOpenClass() throws Exception {
        CompiledOpenClass compiledOpenClass = CompiledOpenClassCache.getInstance().get(this.getDeployment(), this.getModule().getName());
        if (compiledOpenClass != null) {
            return compiledOpenClass;
        }
        XlsLazyModuleOpenClass xlsLazyModuleOpenClass = this.getXlsLazyModuleOpenClass();
        synchronized (xlsLazyModuleOpenClass) {
            compiledOpenClass = CompiledOpenClassCache.getInstance().get(this.getDeployment(), this.getModule().getName());
            if (compiledOpenClass != null) {
                return compiledOpenClass;
            }
            try {
                return MaxThreadsForCompileSemaphore.getInstance().run(new MaxThreadsForCompileSemaphore.Callable<CompiledOpenClass>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public CompiledOpenClass call() throws Exception {
                        CompiledOpenClass compiledOpenClass = null;
                        IPrebindHandler prebindHandler = LazyBinderInvocationHandler.getPrebindHandler();
                        try {
                            LazyBinderInvocationHandler.removePrebindHandler();
                            SingleModuleInstantiationStrategy rulesInstantiationStrategy = RulesInstantiationStrategyFactory.getStrategy((Module)LazyMember.this.getModule(), (boolean)true, (IDependencyManager)LazyMember.this.getDependencyManager(), (ClassLoader)LazyMember.this.getClassLoader());
                            rulesInstantiationStrategy.setServiceClass(EmptyInterface.class);
                            Map parameters = ProjectExternalDependenciesHelper.getExternalParamsWithProjectDependencies((Map)LazyMember.this.dependencyManager.getExternalParameters(), (Collection)new ArrayList<Module>(){
                                private static final long serialVersionUID = 1L;
                                {
                                    this.add(LazyMember.this.getModule());
                                }
                            });
                            rulesInstantiationStrategy.setExternalParameters(parameters);
                            compiledOpenClass = rulesInstantiationStrategy.compile();
                            CompiledOpenClassCache.getInstance().putToCache(LazyMember.this.getDeployment(), LazyMember.this.getModule().getName(), compiledOpenClass);
                            if (LazyMember.this.log.isDebugEnabled()) {
                                LazyMember.this.log.debug("CompiledOpenClass for deploymentName='{}', deploymentVersion='{}', dependencyName='{}' was stored to cache.", new Object[]{LazyMember.this.getDeployment().getName(), LazyMember.this.getDeployment().getVersion().getVersionName(), LazyMember.this.getModule().getName()});
                            }
                            CompiledOpenClass compiledOpenClass2 = compiledOpenClass;
                            return compiledOpenClass2;
                        }
                        catch (Exception ex) {
                            LazyMember.this.log.error("Failed to load dependency '" + LazyMember.this.getModule().getName() + "'.", (Throwable)ex);
                            CompiledOpenClass compiledOpenClass3 = compiledOpenClass;
                            return compiledOpenClass3;
                        }
                        finally {
                            LazyBinderInvocationHandler.setPrebindHandler(prebindHandler);
                        }
                    }
                });
            }
            catch (OpenLCompilationException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw new OpenLCompilationException("Interrupted exception!", (Throwable)e);
            }
            catch (Exception e) {
                throw new OpenLCompilationException("Something wrong!", (Throwable)e);
            }
        }
    }

    public abstract XlsLazyModuleOpenClass getXlsLazyModuleOpenClass();

    public abstract Module getModule();

    public abstract DeploymentDescription getDeployment();

    protected IDependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    protected boolean isExecutionMode() {
        return this.executionMode;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public T getOriginal() {
        return this.original;
    }

    public String getDisplayName(int mode) {
        return this.getOriginal().getDisplayName(mode);
    }

    public String getName() {
        return this.getOriginal().getName();
    }

    public IOpenClass getType() {
        return this.getOriginal().getType();
    }

    public boolean isStatic() {
        return this.getOriginal().isStatic();
    }

    public IMemberMetaInfo getInfo() {
        return this.getOriginal().getInfo();
    }

    public IOpenClass getDeclaringClass() {
        return this.getOriginal().getDeclaringClass();
    }

    public Map<String, Object> getExternalParameters() {
        return this.externalParameters;
    }

    public static interface EmptyInterface {
    }
}

