/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.lazy;

import java.util.Map;
import org.openl.CompiledOpenClass;
import org.openl.dependency.IDependencyManager;
import org.openl.rules.lang.xls.prebind.LazyMethodWrapper;
import org.openl.rules.lang.xls.prebind.XlsLazyModuleOpenClass;
import org.openl.rules.method.ITablePropertiesMethod;
import org.openl.rules.project.model.Module;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.RuleServiceOpenLCompilationException;
import org.openl.rules.ruleservice.publish.lazy.CompiledOpenClassCache;
import org.openl.rules.ruleservice.publish.lazy.LazyMember;
import org.openl.rules.ruleservice.publish.lazy.LazyMemberEvent;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.types.IUriMember;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.java.OpenClassHelper;
import org.openl.vm.IRuntimeEnv;

public abstract class LazyMethod
extends LazyMember<IOpenMethod>
implements IOpenMethod,
IUriMember,
LazyMethodWrapper {
    private String methodName;
    private Class<?>[] argTypes;

    private LazyMethod(String methodName, Class<?>[] argTypes, IOpenMethod original, IDependencyManager dependencyManager, ClassLoader classLoader, boolean executionMode, Map<String, Object> externalParameters) {
        super(dependencyManager, executionMode, classLoader, original, externalParameters);
        this.methodName = methodName;
        this.argTypes = argTypes;
    }

    public static final LazyMethod getLazyMethod(final XlsLazyModuleOpenClass xlsLazyModuleOpenClass, final DeploymentDescription deployment, final Module module, Class<?>[] argTypes, IOpenMethod original, IDependencyManager dependencyManager, ClassLoader classLoader, boolean executionMode, Map<String, Object> externalParameters) {
        LazyMethod lazyMethod = null;
        lazyMethod = original instanceof ITablePropertiesMethod ? new TablePropertiesLazyMethod(original.getName(), argTypes, original, dependencyManager, classLoader, executionMode, externalParameters){

            @Override
            public DeploymentDescription getDeployment() {
                return deployment;
            }

            @Override
            public Module getModule() {
                return module;
            }

            @Override
            public XlsLazyModuleOpenClass getXlsLazyModuleOpenClass() {
                return xlsLazyModuleOpenClass;
            }
        } : new LazyMethod(original.getName(), argTypes, original, dependencyManager, classLoader, executionMode, externalParameters){

            @Override
            public DeploymentDescription getDeployment() {
                return deployment;
            }

            @Override
            public Module getModule() {
                return module;
            }

            @Override
            public XlsLazyModuleOpenClass getXlsLazyModuleOpenClass() {
                return xlsLazyModuleOpenClass;
            }
        };
        CompiledOpenClassCache.getInstance().registerEvent(deployment, module.getName(), new LazyMemberEvent(lazyMethod));
        return lazyMethod;
    }

    @Override
    public IOpenMethod getMember() {
        IOpenMethod cachedMember = (IOpenMethod)this.getCachedMember();
        if (cachedMember != null) {
            return cachedMember;
        }
        try {
            CompiledOpenClass compiledOpenClass = this.getCompiledOpenClassWithThrowErrorExceptionsIfAny();
            IOpenClass[] argOpenTypes = OpenClassHelper.getOpenClasses((IOpenClass)compiledOpenClass.getOpenClass(), (Class[])this.argTypes);
            IOpenMethod openMethod = compiledOpenClass.getOpenClass().getMethod(this.methodName, argOpenTypes);
            this.setCachedMember(openMethod);
            return openMethod;
        }
        catch (Exception e) {
            throw new RuleServiceOpenLCompilationException("Failed to load lazy method.", e);
        }
    }

    public IMethodSignature getSignature() {
        return ((IOpenMethod)this.getOriginal()).getSignature();
    }

    public boolean isConstructor() {
        return ((IOpenMethod)this.getOriginal()).isConstructor();
    }

    public IOpenMethod getCompiledMethod(IRuntimeEnv env) {
        return this.getMember();
    }

    public String getUri() {
        if (this.getOriginal() instanceof IUriMember) {
            return ((IUriMember)this.getOriginal()).getUri();
        }
        throw new IllegalStateException("Implementation doesn't support methods other than ExecutableRulesMethod!");
    }

    public IOpenMethod getMethod() {
        return this;
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        return this.getMember().invoke(target, params, env);
    }

    private static abstract class TablePropertiesLazyMethod
    extends LazyMethod
    implements ITablePropertiesMethod {
        private TablePropertiesLazyMethod(String methodName, Class<?>[] argTypes, IOpenMethod original, IDependencyManager dependencyManager, ClassLoader classLoader, boolean executionMode, Map<String, Object> externalParameters) {
            super(methodName, argTypes, original, dependencyManager, classLoader, executionMode, externalParameters);
        }

        public Map<String, Object> getProperties() {
            if (this.getOriginal() instanceof ITablePropertiesMethod) {
                return ((ITablePropertiesMethod)this.getOriginal()).getProperties();
            }
            throw new IllegalStateException("Original method must be the instance of ITablePropertiesMethod.");
        }

        public ITableProperties getMethodProperties() {
            if (this.getOriginal() instanceof ITablePropertiesMethod) {
                return ((ITablePropertiesMethod)this.getOriginal()).getMethodProperties();
            }
            throw new IllegalStateException("Original method must be the instance of ITablePropertiesMethod.");
        }
    }
}

