/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceDeployException;
import org.openl.rules.ruleservice.core.RuleServiceUndeployException;
import org.openl.rules.ruleservice.publish.AbstractRuleServicePublisher;
import org.openl.rules.ruleservice.simple.RulesFrontend;
import org.openl.rules.ruleservice.simple.RulesFrontendImpl;

public class JavaClassRuleServicePublisher
extends AbstractRuleServicePublisher {
    private RulesFrontend frontend = new RulesFrontendImpl();
    private Map<String, OpenLService> runningServices = new HashMap<String, OpenLService>();

    public RulesFrontend getFrontend() {
        return this.frontend;
    }

    @Override
    public Collection<OpenLService> getServices() {
        Collection<OpenLService> services = this.runningServices.values();
        return new ArrayList<OpenLService>(services);
    }

    @Override
    public OpenLService getServiceByName(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName argument must not be null!");
        }
        return this.runningServices.get(serviceName);
    }

    @Override
    public void deployService(OpenLService service) throws RuleServiceDeployException {
        if (service == null) {
            throw new IllegalArgumentException("service argument must not be null!");
        }
        try {
            OpenLService registeredService = this.getServiceByName(service.getName());
            if (registeredService != null) {
                throw new RuleServiceDeployException(String.format("Service '%s' is already deployed. It has been replaced with new service.", service.getName()));
            }
            this.frontend.registerService(service);
            this.runningServices.put(service.getName(), service);
        }
        catch (Exception e) {
            throw new RuleServiceDeployException("Failed to deploy service.", e);
        }
    }

    @Override
    public void undeployService(String serviceName) throws RuleServiceUndeployException {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName argument must not be null!");
        }
        this.frontend.unregisterService(serviceName);
        if (this.runningServices.remove(serviceName) == null) {
            throw new RuleServiceUndeployException(String.format("Service '%s' hasn't been deployed.", serviceName));
        }
    }

    public void setFrontend(RulesFrontend frontend) {
        if (frontend == null) {
            throw new IllegalArgumentException("frontend arg must not be null!");
        }
        this.frontend = frontend;
    }

    @Override
    public boolean isServiceDeployed(String name) {
        return this.getServiceByName(name) != null;
    }
}

