/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.openl.CompiledOpenClass;
import org.openl.dependency.CompiledDependency;
import org.openl.dependency.IDependencyManager;
import org.openl.dependency.loader.IDependencyLoader;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.lang.xls.prebind.IPrebindHandler;
import org.openl.rules.lang.xls.prebind.XlsLazyModuleOpenClass;
import org.openl.rules.project.dependencies.ProjectExternalDependenciesHelper;
import org.openl.rules.project.instantiation.AbstractProjectDependencyManager;
import org.openl.rules.project.instantiation.RulesInstantiationStrategyFactory;
import org.openl.rules.project.instantiation.SingleModuleInstantiationStrategy;
import org.openl.rules.project.model.Module;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.RuleServiceDeploymentRelatedDependencyManager;
import org.openl.rules.ruleservice.publish.lazy.CompiledOpenClassCache;
import org.openl.rules.ruleservice.publish.lazy.LazyBinderInvocationHandler;
import org.openl.rules.ruleservice.publish.lazy.LazyCompiledOpenClass;
import org.openl.rules.ruleservice.publish.lazy.LazyField;
import org.openl.rules.ruleservice.publish.lazy.LazyInstantiationStrategy;
import org.openl.rules.ruleservice.publish.lazy.LazyMember;
import org.openl.rules.ruleservice.publish.lazy.LazyMethod;
import org.openl.syntax.code.Dependency;
import org.openl.syntax.code.DependencyType;
import org.openl.syntax.code.IDependency;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazyRuleServiceDependencyLoader
implements IDependencyLoader {
    private final Logger log = LoggerFactory.getLogger(LazyRuleServiceDependencyLoader.class);
    private final String name;
    private final DeploymentDescription deployment;
    private final Collection<Module> modules;
    private final boolean realCompileRequred;
    private CompiledOpenClass lazyCompiledOpenClass;
    private final boolean isProject;
    private boolean isCompiledOnce = false;
    private CompiledDependency lazyCompiledDependency = null;

    LazyRuleServiceDependencyLoader(DeploymentDescription deployment, String dependencyName, Collection<Module> modules, boolean realCompileRequred, boolean isProject) {
        if (deployment == null) {
            throw new IllegalArgumentException("deployment arg must not be null.");
        }
        if (dependencyName == null) {
            throw new IllegalArgumentException("dependencyName arg must not be null.");
        }
        if (modules == null || modules.isEmpty()) {
            throw new IllegalArgumentException("modules arg must not be null or empty.");
        }
        this.name = dependencyName;
        this.deployment = deployment;
        this.modules = modules;
        this.realCompileRequred = realCompileRequred;
        this.isProject = isProject;
    }

    private ClassLoader buildClassLoader(AbstractProjectDependencyManager dependencyManager) {
        return dependencyManager.getClassLoader(this.modules.iterator().next().getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CompiledOpenClass compile(String dependencyName, final RuleServiceDeploymentRelatedDependencyManager dependencyManager) throws OpenLCompilationException {
        if (this.lazyCompiledOpenClass != null) {
            return this.lazyCompiledOpenClass;
        }
        IPrebindHandler prebindHandler = LazyBinderInvocationHandler.getPrebindHandler();
        try {
            if (dependencyManager.getCompilationStack().contains(dependencyName)) {
                throw new OpenLCompilationException("Circular dependency has been detected in module: " + dependencyName);
            }
            LazyInstantiationStrategy rulesInstantiationStrategy = null;
            final ClassLoader classLoader = this.buildClassLoader(dependencyManager);
            dependencyManager.getCompilationStack().add(dependencyName);
            this.log.debug("Compiling lazy module for:\n deploymentName='{}',\n deploymentVersion='{}',\n dependencyName='{}'", new Object[]{this.deployment.getName(), this.deployment.getVersion().getVersionName(), dependencyName});
            rulesInstantiationStrategy = this.isProject ? new LazyInstantiationStrategy(this.deployment, this.modules, (IDependencyManager)dependencyManager, classLoader) : RulesInstantiationStrategyFactory.getStrategy((Module)this.modules.iterator().next(), (boolean)true, (IDependencyManager)dependencyManager, (ClassLoader)classLoader);
            rulesInstantiationStrategy.setServiceClass(LazyRuleServiceDependencyLoaderInterface.class);
            final Map parameters = ProjectExternalDependenciesHelper.getExternalParamsWithProjectDependencies((Map)dependencyManager.getExternalParameters(), this.modules);
            rulesInstantiationStrategy.setExternalParameters(parameters);
            try {
                LazyBinderInvocationHandler.setPrebindHandler(new IPrebindHandler(){

                    Module getModuleForMember(IOpenMember member) {
                        String sourceUrl = member.getDeclaringClass().getMetaInfo().getSourceUrl();
                        Module module = this.getModuleForSourceUrl(sourceUrl, LazyRuleServiceDependencyLoader.this.modules);
                        if (module != null) {
                            return module;
                        }
                        throw new OpenlNotCheckedException("Module is not found.");
                    }

                    private Module getModuleForSourceUrl(String sourceUrl, Collection<Module> modules) {
                        if (modules.size() == 1) {
                            return modules.iterator().next();
                        }
                        for (Module module : modules) {
                            String modulePath = module.getRulesRootPath().getPath();
                            try {
                                if (!FilenameUtils.normalize((String)sourceUrl).equals(FilenameUtils.normalize((String)new File(modulePath).getCanonicalFile().toURI().toURL().toExternalForm()))) continue;
                                return module;
                            }
                            catch (Exception e) {
                                LazyRuleServiceDependencyLoader.this.log.warn("Failed to build url for module '{}' with path: {}", new Object[]{module.getName(), modulePath, e});
                            }
                        }
                        return null;
                    }

                    public IOpenMethod processMethodAdded(IOpenMethod method, XlsLazyModuleOpenClass moduleOpenClass) {
                        Module declaringModule = this.getModuleForMember((IOpenMember)method);
                        Class[] argTypes = new Class[method.getSignature().getNumberOfParameters()];
                        for (int i = 0; i < argTypes.length; ++i) {
                            argTypes[i] = method.getSignature().getParameterType(i).getInstanceClass();
                        }
                        return LazyMethod.getLazyMethod(moduleOpenClass, LazyRuleServiceDependencyLoader.this.deployment, declaringModule, argTypes, method, (IDependencyManager)dependencyManager, classLoader, true, parameters);
                    }

                    public IOpenField processFieldAdded(IOpenField field, XlsLazyModuleOpenClass moduleOpenClass) {
                        Module declaringModule = this.getModuleForMember((IOpenMember)field);
                        return LazyField.getLazyField(moduleOpenClass, LazyRuleServiceDependencyLoader.this.deployment, declaringModule, field, (IDependencyManager)dependencyManager, classLoader, true, parameters);
                    }
                });
                try {
                    dependencyManager.compilationBegin(this, this.modules);
                    this.lazyCompiledOpenClass = rulesInstantiationStrategy.compile();
                    dependencyManager.compilationCompleted(this, !this.lazyCompiledOpenClass.hasErrors());
                }
                finally {
                    if (this.lazyCompiledOpenClass == null) {
                        dependencyManager.compilationCompleted(this, false);
                    }
                }
                if (this.modules.size() == 1 && this.realCompileRequred && this.lazyCompiledOpenClass != null) {
                    this.compileAfterLazyCompile(this.lazyCompiledOpenClass, dependencyName, dependencyManager, classLoader, this.modules.iterator().next());
                }
                CompiledOpenClass compiledOpenClass = this.lazyCompiledOpenClass;
                return compiledOpenClass;
            }
            catch (Exception ex) {
                throw new OpenLCompilationException("Failed to load dependency '" + dependencyName + "'.", (Throwable)ex);
            }
            finally {
                LazyBinderInvocationHandler.setPrebindHandler(prebindHandler);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            dependencyManager.getCompilationStack().pollLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileAfterLazyCompile(CompiledOpenClass lazyCompiledOpenClass, String dependencyName, RuleServiceDeploymentRelatedDependencyManager dependencyManager, ClassLoader classLoader, final Module module) throws OpenLCompilationException {
        CompiledOpenClass compiledOpenClass = lazyCompiledOpenClass;
        synchronized (compiledOpenClass) {
            CompiledOpenClass compiledOpenClass2 = CompiledOpenClassCache.getInstance().get(this.deployment, dependencyName);
            if (compiledOpenClass2 != null) {
                return;
            }
            IPrebindHandler prebindHandler = LazyBinderInvocationHandler.getPrebindHandler();
            try {
                LazyBinderInvocationHandler.removePrebindHandler();
                SingleModuleInstantiationStrategy rulesInstantiationStrategy = RulesInstantiationStrategyFactory.getStrategy((Module)module, (boolean)true, (IDependencyManager)dependencyManager, (ClassLoader)classLoader);
                rulesInstantiationStrategy.setServiceClass(LazyMember.EmptyInterface.class);
                Map parameters = ProjectExternalDependenciesHelper.getExternalParamsWithProjectDependencies((Map)dependencyManager.getExternalParameters(), (Collection)new ArrayList<Module>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(module);
                    }
                });
                rulesInstantiationStrategy.setExternalParameters(parameters);
                compiledOpenClass2 = rulesInstantiationStrategy.compile();
                CompiledOpenClassCache.getInstance().putToCache(this.deployment, dependencyName, compiledOpenClass2);
                this.log.debug("CompiledOpenClass for deploymentName='{}', deploymentVersion='{}', dependencyName='{}' was stored to cache.", new Object[]{this.deployment.getName(), this.deployment.getVersion().getVersionName(), dependencyName});
            }
            catch (Exception ex) {
                throw new OpenLCompilationException("Failed to load dependency '" + dependencyName + "'.", (Throwable)ex);
            }
            finally {
                LazyBinderInvocationHandler.setPrebindHandler(prebindHandler);
            }
        }
    }

    public CompiledDependency load(String dependencyName, IDependencyManager dm) throws OpenLCompilationException {
        if (this.name.equals(dependencyName)) {
            if (!(dm instanceof RuleServiceDeploymentRelatedDependencyManager)) {
                throw new IllegalStateException("This loader works only with RuleServiceDeploymentRelatedDependencyManager!");
            }
            RuleServiceDeploymentRelatedDependencyManager dependencyManager = (RuleServiceDeploymentRelatedDependencyManager)dm;
            if (!this.isCompiledOnce) {
                this.compile(dependencyName, dependencyManager);
                this.isCompiledOnce = true;
            }
            if (this.lazyCompiledDependency == null) {
                LazyCompiledOpenClass compiledOpenClass = new LazyCompiledOpenClass(dependencyManager, this, (IDependency)new Dependency(DependencyType.MODULE, new IdentifierNode(null, null, dependencyName, null)));
                this.lazyCompiledDependency = new CompiledDependency(dependencyName, (CompiledOpenClass)compiledOpenClass);
            }
            return this.lazyCompiledDependency;
        }
        return null;
    }

    public static interface LazyRuleServiceDependencyLoaderInterface {
    }
}

