/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openl.OpenClassUtil;
import org.openl.rules.project.model.Module;
import org.openl.rules.ruleservice.core.OpenLServiceInitializer;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationException;
import org.openl.types.IOpenClass;

public final class OpenLService {
    private String name;
    private String url;
    private String serviceClassName;
    private String rmiServiceClassName;
    private Class<?> serviceClass;
    private Class<?> rmiServiceClass;
    private Object serviceBean;
    private IOpenClass openClass;
    private boolean provideRuntimeContext = false;
    private boolean provideVariations = false;
    private Collection<Module> modules;
    private Set<String> publishers;
    private ClassLoader classLoader;
    private OpenLServiceInitializer initializer;

    public ClassLoader getClassLoader() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.classLoader;
    }

    OpenLService(String name, String url, String serviceClassName, String rmiServiceClassName, boolean provideRuntimeContext, boolean provideVariations, Set<String> publishers, Collection<Module> modules, ClassLoader classLoader, Class<?> serviceClass) {
        if (name == null) {
            throw new IllegalArgumentException("name arg must not be null.");
        }
        this.name = name;
        this.url = url;
        this.modules = modules != null ? Collections.unmodifiableCollection(modules) : Collections.emptyList();
        this.serviceClassName = serviceClassName;
        this.rmiServiceClassName = rmiServiceClassName;
        this.provideRuntimeContext = provideRuntimeContext;
        this.provideVariations = provideVariations;
        this.publishers = publishers != null ? Collections.unmodifiableSet(publishers) : Collections.emptySet();
        this.classLoader = classLoader;
        this.serviceClass = serviceClass;
    }

    private OpenLService(OpenLServiceBuilder builder, OpenLServiceInitializer initializer) {
        this(builder.name, builder.url, builder.serviceClassName, builder.rmiServiceClassName, builder.provideRuntimeContext, builder.provideVariations, builder.publishers, builder.modules, builder.classLoader, builder.serviceClass);
        if (initializer == null) {
            throw new NullPointerException("initializer can't be null!");
        }
        this.initializer = initializer;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public Collection<String> getPublishers() {
        if (this.publishers == null) {
            return Collections.emptyList();
        }
        return this.publishers;
    }

    public Collection<Module> getModules() {
        if (this.modules == null) {
            return Collections.emptyList();
        }
        return this.modules;
    }

    private void ensureInitialization() throws RuleServiceInstantiationException {
        this.initializer.ensureInitialization(this);
    }

    public String getServiceClassName() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.serviceClassName;
    }

    void setServiceClassName(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    public String getRmiServiceClassName() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.rmiServiceClassName;
    }

    void setRmiServiceClassName(String rmiServiceClassName) {
        this.rmiServiceClassName = rmiServiceClassName;
    }

    public boolean isProvideRuntimeContext() {
        return this.provideRuntimeContext;
    }

    public boolean isProvideVariations() {
        return this.provideVariations;
    }

    public Class<?> getServiceClass() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.serviceClass;
    }

    public Class<?> getRmiServiceClass() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.rmiServiceClass;
    }

    void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    void setServiceClass(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    void setRmiServiceClass(Class<?> rmiServiceClass) {
        this.rmiServiceClass = rmiServiceClass;
    }

    public Object getServiceBean() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.serviceBean;
    }

    void setServiceBean(Object serviceBean) {
        this.serviceBean = serviceBean;
    }

    void setOpenClass(IOpenClass openClass) {
        this.openClass = openClass;
    }

    public IOpenClass getOpenClass() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.openClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenLService other = (OpenLService)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void destroy() {
        try {
            ClassLoader classloader = this.getClassLoader();
            OpenClassUtil.releaseClassLoader((ClassLoader)classloader);
        }
        catch (RuleServiceInstantiationException ruleServiceInstantiationException) {
            // empty catch block
        }
    }

    public static class OpenLServiceBuilder {
        private String name;
        private String url;
        private String serviceClassName;
        private String rmiServiceClassName;
        private Class<?> serviceClass;
        private boolean provideRuntimeContext = false;
        private boolean provideVariations = false;
        private Collection<Module> modules;
        private Set<String> publishers;
        private ClassLoader classLoader;

        public OpenLServiceBuilder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public OpenLServiceBuilder setPublishers(Set<String> publishers) {
            this.publishers = publishers == null ? new HashSet<String>(0) : publishers;
            return this;
        }

        public OpenLServiceBuilder addPublishers(Set<String> publishers) {
            if (this.publishers == null) {
                this.publishers = new HashSet<String>();
            }
            if (publishers != null) {
                this.publishers.addAll(publishers);
            }
            return this;
        }

        public OpenLServiceBuilder addPublisher(String publisher) {
            if (this.publishers == null) {
                this.publishers = new HashSet<String>();
            }
            if (publisher != null) {
                this.publishers.add(publisher);
            }
            return this;
        }

        public OpenLServiceBuilder setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name arg must not be null.");
            }
            this.name = name;
            return this;
        }

        public OpenLServiceBuilder setServiceClassName(String serviceClassName) {
            this.serviceClassName = serviceClassName;
            return this;
        }

        public OpenLServiceBuilder setRmiServiceClassName(String rmiServiceClassName) {
            this.rmiServiceClassName = rmiServiceClassName;
            return this;
        }

        public OpenLServiceBuilder setProvideRuntimeContext(boolean provideRuntimeContext) {
            this.provideRuntimeContext = provideRuntimeContext;
            return this;
        }

        public OpenLServiceBuilder setProvideVariations(boolean provideVariations) {
            this.provideVariations = provideVariations;
            return this;
        }

        public OpenLServiceBuilder setModules(Collection<Module> modules) {
            this.modules = modules == null ? new ArrayList<Module>(0) : new ArrayList<Module>(modules);
            return this;
        }

        public OpenLServiceBuilder addModules(Collection<Module> modules) {
            if (this.modules == null) {
                this.modules = new ArrayList<Module>();
            }
            this.modules.addAll(modules);
            return this;
        }

        public OpenLServiceBuilder addModule(Module module) {
            if (this.modules == null) {
                this.modules = new ArrayList<Module>();
            }
            if (module != null) {
                this.modules.add(module);
            }
            return this;
        }

        public OpenLServiceBuilder setUrl(String url) {
            this.url = url;
            return this;
        }

        public OpenLServiceBuilder setServiceClass(Class<?> serviceClass) {
            this.serviceClass = serviceClass;
            return this;
        }

        public OpenLService build(OpenLServiceInitializer initializer) {
            if (this.name == null) {
                throw new IllegalStateException("Field 'name' is required for building ServiceDescription.");
            }
            return new OpenLService(this, initializer);
        }
    }
}

