/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.openl.dependency.CompiledDependency;
import org.openl.dependency.loader.IDependencyLoader;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.common.ProjectException;
import org.openl.rules.project.IRulesDeploySerializer;
import org.openl.rules.project.abstraction.AProject;
import org.openl.rules.project.abstraction.AProjectArtefact;
import org.openl.rules.project.abstraction.AProjectResource;
import org.openl.rules.project.abstraction.Deployment;
import org.openl.rules.project.dependencies.ProjectExternalDependenciesHelper;
import org.openl.rules.project.instantiation.AbstractProjectDependencyManager;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.project.xml.XmlRulesDeploySerializer;
import org.openl.rules.ruleservice.core.CompilationTimeLoggingDependencyManager;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.LazyRuleServiceDependencyLoader;
import org.openl.rules.ruleservice.core.MaxThreadsForCompileSemaphore;
import org.openl.rules.ruleservice.core.RuleServiceDependencyLoader;
import org.openl.rules.ruleservice.loader.RuleServiceLoader;
import org.openl.syntax.code.IDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class RuleServiceDeploymentRelatedDependencyManager
extends AbstractProjectDependencyManager
implements CompilationTimeLoggingDependencyManager {
    private final Logger log = LoggerFactory.getLogger(RuleServiceDeploymentRelatedDependencyManager.class);
    private RuleServiceLoader ruleServiceLoader;
    private DeploymentDescription deploymentDescription;
    private Collection<ProjectDescriptor> projectDescriptors = null;
    List<IDependencyLoader> dependencyLoaders = null;
    Collection<String> dependencyNames = null;
    private IRulesDeploySerializer rulesDeploySerializer = new XmlRulesDeploySerializer();
    private boolean lazy;
    private PathMatcher wildcardPatternMatcher = new AntPathMatcher();
    private ThreadLocal<Stack<CompilationInfo>> compliationInfoThreadLocal = ThreadLocal.withInitial(Stack::new);

    public boolean isLazy() {
        return this.lazy;
    }

    public RuleServiceLoader getRuleServiceLoader() {
        return this.ruleServiceLoader;
    }

    public Collection<String> getAllDependencies() {
        if (this.dependencyLoaders == null) {
            this.initDependencyLoaders();
        }
        return this.dependencyNames;
    }

    @Override
    public void compilationBegin(IDependencyLoader dependencyLoader, Collection<Module> modules) {
        CompilationInfo compilationInfo = new CompilationInfo();
        compilationInfo.time = System.currentTimeMillis();
        compilationInfo.dependencyLoader = dependencyLoader;
        compilationInfo.modules = Collections.unmodifiableCollection(modules);
        Stack<CompilationInfo> compilationInfoStack = this.compliationInfoThreadLocal.get();
        compilationInfoStack.push(compilationInfo);
    }

    @Override
    public void compilationCompleted(IDependencyLoader dependencyLoader, boolean successed) {
        try {
            Stack<CompilationInfo> compilationInfoStack = this.compliationInfoThreadLocal.get();
            CompilationInfo compilationInfo = compilationInfoStack.pop();
            if (compilationInfo.dependencyLoader != dependencyLoader) {
                throw new IllegalStateException("Illegal State!");
            }
            Collection<Module> modules = compilationInfo.modules;
            long t = System.currentTimeMillis() - compilationInfo.time;
            if (modules.size() == 1 && successed && !(dependencyLoader instanceof LazyRuleServiceDependencyLoader)) {
                Module module = modules.iterator().next();
                this.log.info(String.format("Module '%s' in project '%s' has been compiled in %s ms.", module.getName(), module.getProject().getName(), String.valueOf(t - compilationInfo.embeddedTime)));
            }
            if (!compilationInfoStack.isEmpty()) {
                CompilationInfo compilationInfoParent = compilationInfoStack.peek();
                compilationInfoParent.embeddedTime += t;
            }
        }
        catch (Exception e) {
            this.log.error("Unexpected exception!", (Throwable)e);
        }
    }

    public CompiledDependency loadDependency(final IDependency dependency) throws OpenLCompilationException {
        try {
            return MaxThreadsForCompileSemaphore.getInstance().run(new MaxThreadsForCompileSemaphore.Callable<CompiledDependency>(){

                @Override
                public CompiledDependency call() throws Exception {
                    return RuleServiceDeploymentRelatedDependencyManager.super.loadDependency(dependency);
                }
            });
        }
        catch (OpenLCompilationException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new OpenLCompilationException("Interrupted exception!", (Throwable)e);
        }
        catch (Exception e) {
            throw new OpenLCompilationException("Something wrong!", (Throwable)e);
        }
    }

    public RuleServiceDeploymentRelatedDependencyManager(DeploymentDescription deploymentDescription, RuleServiceLoader ruleServiceLoader, ClassLoader rootClassLoader, boolean lazy) {
        super(rootClassLoader);
        if (deploymentDescription == null) {
            throw new IllegalArgumentException("deploymentDescription must not be null!");
        }
        if (ruleServiceLoader == null) {
            throw new IllegalArgumentException("ruleService must not be null!");
        }
        this.deploymentDescription = deploymentDescription;
        this.ruleServiceLoader = ruleServiceLoader;
        this.lazy = lazy;
        super.setExecutionMode(true);
    }

    public void setExecutionMode(boolean executionMode) {
        throw new UnsupportedOperationException("This dependency manager doesn't support executionMode=false!");
    }

    public void reset(IDependency dependency) {
        throw new UnsupportedOperationException();
    }

    public void resetAll() {
        throw new UnsupportedOperationException();
    }

    public Collection<ProjectDescriptor> getProjectDescriptors() {
        if (this.dependencyLoaders == null) {
            this.initDependencyLoaders();
        }
        return this.projectDescriptors;
    }

    public List<IDependencyLoader> getDependencyLoaders() {
        if (this.dependencyLoaders == null) {
            this.initDependencyLoaders();
        }
        return this.dependencyLoaders;
    }

    private boolean compilationAfterLazyCompilationRequred(Set<String> wildcardPatterns, String moduleName) {
        for (String pattern : wildcardPatterns) {
            if (!this.wildcardPatternMatcher.match(pattern, moduleName)) continue;
            return true;
        }
        return false;
    }

    public final IRulesDeploySerializer getRulesDeploySerializer() {
        return this.rulesDeploySerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initDependencyLoaders() {
        if (this.projectDescriptors == null && this.dependencyLoaders == null) {
            this.dependencyLoaders = new ArrayList<IDependencyLoader>();
            this.projectDescriptors = new ArrayList<ProjectDescriptor>();
            this.dependencyNames = new HashSet<String>();
            Collection<Deployment> deployments = this.ruleServiceLoader.getDeployments();
            for (Deployment deployment : deployments) {
                String deploymentName = deployment.getDeploymentName();
                CommonVersion deploymentVersion = deployment.getCommonVersion();
                if (!this.deploymentDescription.getName().equals(deploymentName) || !this.deploymentDescription.getVersion().equals(deploymentVersion)) continue;
                for (AProject project : deployment.getProjects()) {
                    String projectName = project.getName();
                    try {
                        Collection<Module> modulesOfProject = this.ruleServiceLoader.resolveModulesForProject(deploymentName, deploymentVersion, projectName);
                        ProjectDescriptor projectDescriptor = null;
                        HashSet<String> wildcardPatterns = new HashSet<String>();
                        if (!modulesOfProject.isEmpty()) {
                            Module firstModule = modulesOfProject.iterator().next();
                            projectDescriptor = firstModule.getProject();
                            InputStream content = null;
                            RulesDeploy rulesDeploy = null;
                            try {
                                AProjectArtefact artifact = project.getArtefact("rules-deploy.xml");
                                if (artifact instanceof AProjectResource) {
                                    AProjectResource resource = (AProjectResource)artifact;
                                    content = resource.getContent();
                                    rulesDeploy = this.getRulesDeploySerializer().deserialize(content);
                                    RulesDeploy.WildcardPattern[] compilationPatterns = rulesDeploy.getLazyModulesForCompilationPatterns();
                                    if (compilationPatterns != null) {
                                        for (RulesDeploy.WildcardPattern wp : compilationPatterns) {
                                            wildcardPatterns.add(wp.getValue());
                                        }
                                    }
                                }
                            }
                            catch (ProjectException e) {
                            }
                            finally {
                                if (content != null) {
                                    try {
                                        content.close();
                                    }
                                    catch (IOException e) {
                                        this.log.error(e.getMessage(), (Throwable)e);
                                    }
                                }
                            }
                            for (Module m : modulesOfProject) {
                                Object moduleLoader;
                                String moduleName = m.getName();
                                List<Module> module = Arrays.asList(m);
                                if (this.isLazy()) {
                                    boolean compileAfterLazyCompilation = this.compilationAfterLazyCompilationRequred(wildcardPatterns, moduleName);
                                    moduleLoader = new LazyRuleServiceDependencyLoader(this.deploymentDescription, moduleName, module, compileAfterLazyCompilation, false);
                                } else {
                                    moduleLoader = new RuleServiceDependencyLoader(moduleName, module, false);
                                }
                                this.dependencyLoaders.add((IDependencyLoader)moduleLoader);
                                this.dependencyNames.add(moduleName);
                            }
                        }
                        if (projectDescriptor == null) continue;
                        Object projectLoader = this.isLazy() ? new LazyRuleServiceDependencyLoader(this.deploymentDescription, ProjectExternalDependenciesHelper.buildDependencyNameForProjectName((String)projectDescriptor.getName()), projectDescriptor.getModules(), false, true) : new RuleServiceDependencyLoader(ProjectExternalDependenciesHelper.buildDependencyNameForProjectName((String)projectDescriptor.getName()), projectDescriptor.getModules(), true);
                        this.projectDescriptors.add(projectDescriptor);
                        this.dependencyLoaders.add((IDependencyLoader)projectLoader);
                    }
                    catch (Exception e) {
                        this.log.error("Failed to build dependency manager loaders for project '{}' in deployment '{}'!", new Object[]{projectName, deploymentName, e});
                    }
                }
            }
        }
    }

    private static class CompilationInfo {
        long time;
        long embeddedTime;
        IDependencyLoader dependencyLoader;
        Collection<Module> modules;

        private CompilationInfo() {
        }
    }
}

