/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleService;
import org.openl.rules.ruleservice.core.RuleServiceDeployException;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationException;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationFactory;
import org.openl.rules.ruleservice.core.RuleServiceOpenLServiceInstantiationFactoryImpl;
import org.openl.rules.ruleservice.core.RuleServiceRedeployLock;
import org.openl.rules.ruleservice.core.RuleServiceUndeployException;
import org.openl.rules.ruleservice.core.ServiceDescription;
import org.openl.rules.ruleservice.publish.RuleServicePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleServiceImpl
implements RuleService {
    private final Logger log = LoggerFactory.getLogger(RuleServiceImpl.class);
    private RuleServicePublisher ruleServicePublisher;
    private RuleServiceInstantiationFactory ruleServiceInstantiationFactory;
    private Map<String, ServiceDescription> mapping = new HashMap<String, ServiceDescription>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redeploy(ServiceDescription serviceDescription) throws RuleServiceDeployException, RuleServiceUndeployException {
        block7: {
            OpenLService service = this.ruleServicePublisher.getServiceByName(serviceDescription.getName());
            if (service == null) {
                throw new RuleServiceUndeployException(String.format("There is no running service with name '%s'.", serviceDescription.getName()));
            }
            try {
                ServiceDescription sd = this.mapping.get(serviceDescription.getName());
                if (sd == null) {
                    throw new IllegalStateException("Invalid state!!!");
                }
                if (sd.getDeployment().getVersion().compareTo((Object)serviceDescription.getDeployment().getVersion()) == 0) break block7;
                OpenLService openLService = this.ruleServiceInstantiationFactory.createService(serviceDescription);
                Lock lock = RuleServiceRedeployLock.getInstance().getWriteLock();
                try {
                    lock.lock();
                    this.undeploy(service.getName());
                    this.deploy(serviceDescription, openLService);
                }
                finally {
                    lock.unlock();
                }
            }
            catch (RuleServiceInstantiationException e) {
                throw new RuleServiceDeployException("Failed on redeploy service", e);
            }
        }
    }

    @Override
    public void undeploy(String serviceName) throws RuleServiceUndeployException {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName arg must not be null.");
        }
        OpenLService service = this.ruleServicePublisher.getServiceByName(serviceName);
        if (service == null) {
            throw new RuleServiceUndeployException(String.format("There is no running service '%s'", serviceName));
        }
        ServiceDescription serviceDescription = this.mapping.get(serviceName);
        if (serviceDescription == null) {
            throw new IllegalStateException("Illegal State!!!");
        }
        this.ruleServicePublisher.undeploy(serviceName);
        this.mapping.remove(serviceDescription.getName());
        if (this.ruleServiceInstantiationFactory instanceof RuleServiceOpenLServiceInstantiationFactoryImpl) {
            ((RuleServiceOpenLServiceInstantiationFactoryImpl)this.ruleServiceInstantiationFactory).clear(serviceDescription.getDeployment());
        }
        service.destroy();
        this.log.info("Service '{}' was undeployed succesfully.", (Object)service.getName());
    }

    public Collection<OpenLService> getServices() {
        Collection<OpenLService> services = this.ruleServicePublisher.getServices();
        return new ArrayList<OpenLService>(services);
    }

    @Override
    public OpenLService getServiceByName(String serviceName) {
        return this.ruleServicePublisher.getServiceByName(serviceName);
    }

    @Override
    public void deploy(ServiceDescription serviceDescription) throws RuleServiceDeployException {
        OpenLService service = this.ruleServicePublisher.getServiceByName(serviceDescription.getName());
        if (service != null) {
            throw new RuleServiceDeployException("The service with name '" + serviceDescription.getName() + "' has already been deployed!");
        }
        try {
            OpenLService newService = this.ruleServiceInstantiationFactory.createService(serviceDescription);
            this.deploy(serviceDescription, newService);
        }
        catch (RuleServiceInstantiationException e) {
            throw new RuleServiceDeployException("Failed on deploy a service.", e);
        }
    }

    private void deploy(ServiceDescription serviceDescription, OpenLService newService) throws RuleServiceDeployException {
        ServiceDescription sd = this.mapping.get(serviceDescription.getName());
        if (sd != null) {
            throw new IllegalStateException("Illegal State!!");
        }
        this.ruleServicePublisher.deploy(newService);
        this.mapping.put(serviceDescription.getName(), serviceDescription);
        this.log.info("Service '{}' was deployed succesfully.", (Object)serviceDescription.getName());
    }

    public RuleServicePublisher getRuleServicePublisher() {
        return this.ruleServicePublisher;
    }

    public void setRuleServicePublisher(RuleServicePublisher ruleServicePublisher) {
        if (ruleServicePublisher == null) {
            throw new IllegalArgumentException("ruleServicePublisher arg must not be null.");
        }
        this.ruleServicePublisher = ruleServicePublisher;
    }

    public RuleServiceInstantiationFactory getRuleServiceInstantiationFactory() {
        return this.ruleServiceInstantiationFactory;
    }

    public void setRuleServiceInstantiationFactory(RuleServiceInstantiationFactory ruleServiceInstantiationFactory) {
        if (ruleServiceInstantiationFactory == null) {
            throw new IllegalArgumentException("ruleServiceInstantiationFactory arg must not be null.");
        }
        this.ruleServiceInstantiationFactory = ruleServiceInstantiationFactory;
    }
}

