/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.ruleservice.core.annotations.ServiceExtraMethod;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAfterInterceptor;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAfterInterceptors;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAroundInterceptor;
import org.openl.rules.variation.VariationsResult;
import org.openl.util.ClassUtils;
import org.openl.util.generation.InterfaceTransformer;

public abstract class RuleServiceInstantiationFactoryHelper {
    private static final String UNDECORATED_CLASS_NAME_SUFFIX = "$Original";

    public static Class<?> getInterfaceForInstantiationStrategy(RulesInstantiationStrategy instantiationStrategy, Class<?> serviceClass) {
        return RuleServiceInstantiationFactoryHelper.processInterface(instantiationStrategy, serviceClass, false);
    }

    public static Class<?> getInterfaceForService(RulesInstantiationStrategy instantiationStrategy, Class<?> serviceClass) {
        return RuleServiceInstantiationFactoryHelper.processInterface(instantiationStrategy, serviceClass, true);
    }

    public static Class<?> processInterface(RulesInstantiationStrategy instantiationStrategy, Class<?> serviceClass, boolean skipServiceExtraMethodAnnotation) {
        boolean requresChangingReturnType = RuleServiceInstantiationFactoryHelper.hasMethodsWithReturnTypeNeedsChange(serviceClass);
        boolean hasServiceExtraMethodAnnotationMethods = false;
        if (!skipServiceExtraMethodAnnotation) {
            hasServiceExtraMethodAnnotationMethods = RuleServiceInstantiationFactoryHelper.hasMethodsWithServiceExtraMethodAnnotation(serviceClass);
        }
        if (!requresChangingReturnType && !hasServiceExtraMethodAnnotationMethods) {
            return serviceClass;
        }
        Set<Method> methodsWithReturnTypeNeedsChange = RuleServiceInstantiationFactoryHelper.getMethodsWithReturnTypeNeedsChange(serviceClass);
        Set<Object> methodsWithServiceExtraMethodAnnotation = null;
        methodsWithServiceExtraMethodAnnotation = skipServiceExtraMethodAnnotation ? Collections.emptySet() : RuleServiceInstantiationFactoryHelper.getMethodsWithServiceExtraMethodAnnotation(serviceClass);
        ClassWriter classWriter = new ClassWriter(0);
        RuleserviceInterceptorsSupportClassVisitor classVisitor = new RuleserviceInterceptorsSupportClassVisitor((ClassVisitor)classWriter, methodsWithReturnTypeNeedsChange, methodsWithServiceExtraMethodAnnotation);
        String className = serviceClass.getName() + UNDECORATED_CLASS_NAME_SUFFIX;
        InterfaceTransformer transformer = new InterfaceTransformer(serviceClass, className);
        transformer.accept((ClassVisitor)classVisitor);
        classWriter.visitEnd();
        try {
            ClassUtils.defineClass((String)className, (byte[])classWriter.toByteArray(), (ClassLoader)instantiationStrategy.getClassLoader());
            return Class.forName(className, true, instantiationStrategy.getClassLoader());
        }
        catch (Exception e) {
            throw new OpenlNotCheckedException((Throwable)e);
        }
    }

    private static boolean isMethodWithReturnTypeNeedsChange(Method method) {
        if (method.getAnnotation(ServiceCallAfterInterceptor.class) != null && !method.getReturnType().equals(VariationsResult.class)) {
            return true;
        }
        ServiceCallAfterInterceptors serviceCallAfterInterceptors = method.getAnnotation(ServiceCallAfterInterceptors.class);
        if (serviceCallAfterInterceptors != null && serviceCallAfterInterceptors.value().length > 0 && !method.getReturnType().equals(VariationsResult.class)) {
            return true;
        }
        return method.getAnnotation(ServiceCallAroundInterceptor.class) != null && !method.getReturnType().equals(VariationsResult.class);
    }

    private static boolean isMethodWithServiceExtraMethodAnnotation(Method method) {
        return method.getAnnotation(ServiceExtraMethod.class) != null;
    }

    public static boolean hasMethodsWithReturnTypeNeedsChange(Class<?> serviceClass) {
        for (Method method : serviceClass.getMethods()) {
            if (!RuleServiceInstantiationFactoryHelper.isMethodWithReturnTypeNeedsChange(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMethodsWithServiceExtraMethodAnnotation(Class<?> serviceClass) {
        for (Method method : serviceClass.getMethods()) {
            if (!RuleServiceInstantiationFactoryHelper.isMethodWithServiceExtraMethodAnnotation(method)) continue;
            return true;
        }
        return false;
    }

    public static Set<Method> getMethodsWithReturnTypeNeedsChange(Class<?> serviceClass) {
        HashSet<Method> ret = new HashSet<Method>();
        for (Method method : serviceClass.getMethods()) {
            if (!RuleServiceInstantiationFactoryHelper.isMethodWithReturnTypeNeedsChange(method)) continue;
            ret.add(method);
        }
        return ret;
    }

    public static Set<Method> getMethodsWithServiceExtraMethodAnnotation(Class<?> serviceClass) {
        HashSet<Method> ret = new HashSet<Method>();
        for (Method method : serviceClass.getMethods()) {
            if (!RuleServiceInstantiationFactoryHelper.isMethodWithServiceExtraMethodAnnotation(method)) continue;
            ret.add(method);
        }
        return ret;
    }

    private static class RuleserviceInterceptorsSupportClassVisitor
    extends ClassVisitor {
        private Collection<Method> methodsWithReturnTypeNeedsChange;
        private Collection<Method> methodsWithServiceExtraMethodAnnotation;

        public RuleserviceInterceptorsSupportClassVisitor(ClassVisitor visitor, Collection<Method> methodsWithReturnTypeNeedsChange, Collection<Method> methodsWithServiceExtraMethodAnnotation) {
            super(327680, visitor);
            this.methodsWithReturnTypeNeedsChange = methodsWithReturnTypeNeedsChange;
            this.methodsWithServiceExtraMethodAnnotation = methodsWithServiceExtraMethodAnnotation;
        }

        public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
            boolean containsServiceExtraMethod = false;
            for (Method method : this.methodsWithServiceExtraMethodAnnotation) {
                if (!arg1.equals(method.getName()) || !arg2.equals(Type.getMethodDescriptor((Method)method))) continue;
                containsServiceExtraMethod = true;
                break;
            }
            if (containsServiceExtraMethod) {
                return null;
            }
            boolean containsReturnTypeNeedsChangeMethod = false;
            for (Method method : this.methodsWithReturnTypeNeedsChange) {
                if (!arg1.equals(method.getName()) || !arg2.equals(Type.getMethodDescriptor((Method)method))) continue;
                containsReturnTypeNeedsChangeMethod = true;
                break;
            }
            if (containsReturnTypeNeedsChangeMethod) {
                return super.visitMethod(arg0, arg1, this.convertReturnType(arg2), arg3, arg4);
            }
            return super.visitMethod(arg0, arg1, arg2, arg3, arg4);
        }

        private String convertReturnType(String arg2) {
            int index = arg2.lastIndexOf(41);
            return arg2.substring(0, index + 1) + Type.getDescriptor(Object.class);
        }
    }
}

