/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openl.rules.project.model.Module;
import org.openl.rules.ruleservice.core.DeploymentDescription;

public final class ServiceDescription {
    private String name;
    private String url;
    private String serviceClassName;
    private String rmiServiceClassName;
    private String annotationTemplateClassName;
    private boolean provideRuntimeContext;
    private boolean provideVariations;
    private Map<String, Object> configuration;
    private Collection<Module> modules;
    private DeploymentDescription deployment;
    private String[] publishers;

    ServiceDescription(String name, String url, String serviceClassName, String rmiServiceClassName, String annotationTemplateClassName, boolean provideRuntimeContext, boolean provideVariations, Collection<Module> modules, DeploymentDescription deployment, Map<String, Object> configuration, String[] publishers) {
        this.name = name;
        this.url = url;
        this.serviceClassName = serviceClassName;
        this.provideRuntimeContext = provideRuntimeContext;
        this.rmiServiceClassName = rmiServiceClassName;
        this.provideVariations = provideVariations;
        this.annotationTemplateClassName = annotationTemplateClassName;
        this.configuration = configuration == null ? Collections.emptyMap() : Collections.unmodifiableMap(configuration);
        this.modules = modules != null ? Collections.unmodifiableCollection(modules) : Collections.emptySet();
        this.publishers = publishers;
        this.deployment = deployment;
    }

    private ServiceDescription(ServiceDescriptionBuilder builder) {
        this(builder.name, builder.url, builder.serviceClassName, builder.rmiServiceClassName, builder.annotationTemplateClassName, builder.provideRuntimeContext, builder.provideVariations, builder.modules, builder.deployment, builder.configuration, builder.publishers.toArray(new String[0]));
    }

    public String getAnnotationTemplateClassName() {
        return this.annotationTemplateClassName;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public String getRmiServiceClassName() {
        return this.rmiServiceClassName;
    }

    public boolean isProvideRuntimeContext() {
        return this.provideRuntimeContext;
    }

    public boolean isProvideVariations() {
        return this.provideVariations;
    }

    public Collection<Module> getModules() {
        return this.modules;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public DeploymentDescription getDeployment() {
        return this.deployment;
    }

    public String[] getPublishers() {
        return this.publishers;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceDescription other = (ServiceDescription)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static class ServiceDescriptionBuilder {
        private String name;
        private String url;
        private String serviceClassName;
        private String rmiServiceClassName;
        private String annotationTemplateClassName;
        private boolean provideRuntimeContext;
        private boolean provideVariations = false;
        private Map<String, Object> configuration;
        private Collection<Module> modules;
        private DeploymentDescription deployment;
        private Set<String> publishers = new HashSet<String>();

        public void setPublishers(String[] publishers) {
            this.publishers = new HashSet<String>();
            if (publishers != null) {
                for (String publisher : publishers) {
                    this.publishers.add(publisher);
                }
            }
        }

        public void addPublisher(String key) {
            if (key == null) {
                throw new IllegalArgumentException("key argument must not be null.");
            }
            if (this.publishers == null) {
                this.publishers = new HashSet<String>();
            }
            this.publishers.add(key.toUpperCase());
        }

        public ServiceDescriptionBuilder setAnnotationTemplateClassName(String annotationTemplateClassName) {
            this.annotationTemplateClassName = annotationTemplateClassName;
            return this;
        }

        public ServiceDescriptionBuilder setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name arg must not be null.");
            }
            this.name = name;
            return this;
        }

        public ServiceDescriptionBuilder setUrl(String url) {
            this.url = url;
            return this;
        }

        public ServiceDescriptionBuilder setModules(Collection<Module> modules) {
            this.modules = modules == null ? new HashSet<Module>(0) : new HashSet<Module>(modules);
            return this;
        }

        public ServiceDescriptionBuilder addModules(Collection<Module> modules) {
            if (this.modules == null) {
                this.modules = new HashSet<Module>(modules);
            } else {
                this.modules.addAll(modules);
            }
            return this;
        }

        public ServiceDescriptionBuilder addModule(Module module) {
            if (this.modules == null) {
                this.modules = new HashSet<Module>(0);
            }
            if (module != null) {
                this.modules.add(module);
            }
            return this;
        }

        public ServiceDescriptionBuilder setProvideRuntimeContext(boolean provideRuntimeContext) {
            this.provideRuntimeContext = provideRuntimeContext;
            return this;
        }

        public ServiceDescriptionBuilder setServiceClassName(String serviceClassName) {
            this.serviceClassName = serviceClassName;
            return this;
        }

        public ServiceDescriptionBuilder setRmiServiceClassName(String rmiServiceClassName) {
            this.rmiServiceClassName = rmiServiceClassName;
            return this;
        }

        public ServiceDescriptionBuilder setProvideVariations(boolean provideVariations) {
            this.provideVariations = provideVariations;
            return this;
        }

        public ServiceDescriptionBuilder setDeployment(DeploymentDescription deployment) {
            this.deployment = deployment;
            return this;
        }

        public ServiceDescriptionBuilder addConfigurationProperty(String key, Object value) {
            if (this.configuration == null) {
                this.configuration = new HashMap<String, Object>();
            }
            this.configuration.put(key, value);
            return this;
        }

        public ServiceDescriptionBuilder setConfiguration(Map<String, Object> configuration) {
            this.configuration = configuration;
            return this;
        }

        public ServiceDescription build() {
            if (this.name == null) {
                throw new IllegalStateException("Field 'name' is required for building ServiceDescription");
            }
            if (this.modules == null) {
                throw new IllegalStateException("Field 'modules' is required for building ServiceDescription");
            }
            if (this.deployment == null) {
                throw new IllegalStateException("Field 'deployment' is required for building ServiceDescription");
            }
            return new ServiceDescription(this);
        }
    }
}

