/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core.interceptors;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.binding.impl.cast.OutsideOfValidDomainException;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenLException;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.ruleservice.core.ExceptionType;
import org.openl.rules.ruleservice.core.RuleServiceOpenLCompilationException;
import org.openl.rules.ruleservice.core.RuleServiceRuntimeException;
import org.openl.rules.ruleservice.core.RuleServiceWrapperException;
import org.openl.rules.ruleservice.core.annotations.ServiceExtraMethod;
import org.openl.rules.ruleservice.core.annotations.ServiceExtraMethodHandler;
import org.openl.rules.ruleservice.core.interceptors.ServiceMethodAfterAdvice;
import org.openl.rules.ruleservice.core.interceptors.ServiceMethodAroundAdvice;
import org.openl.rules.ruleservice.core.interceptors.ServiceMethodBeforeAdvice;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAfterInterceptor;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAfterInterceptors;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAroundInterceptor;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallBeforeInterceptor;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallBeforeInterceptors;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallInterceptorGroup;
import org.openl.rules.testmethod.OpenLUserRuntimeException;
import org.openl.runtime.IEngineWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

public final class ServiceInvocationAdvice
implements MethodInterceptor,
Ordered {
    private final Logger log = LoggerFactory.getLogger(ServiceInvocationAdvice.class);
    private static final String MSG_SEPARATOR = "; ";
    private Map<Method, List<ServiceMethodBeforeAdvice>> beforeInterceptors = new HashMap<Method, List<ServiceMethodBeforeAdvice>>();
    private Map<Method, List<ServiceMethodAfterAdvice<?>>> afterInterceptors = new HashMap();
    private Map<Method, ServiceMethodAroundAdvice<?>> aroundInterceptors = new HashMap();
    private Map<Method, ServiceExtraMethodHandler<?>> serviceExtraMethodAnnotations = new HashMap();
    private Object serviceBean;
    private Class<?> serviceClass;
    private ServiceCallInterceptorGroup[] serviceCallInterceptorGroupSupported;
    private ClassLoader serviceClassLoader;

    public ServiceInvocationAdvice(Object serviceBean, Class<?> serviceClass, ServiceCallInterceptorGroup[] serviceCallInterceptorGroupSupported, ClassLoader serviceClassLoader) {
        this.serviceBean = serviceBean;
        this.serviceClass = serviceClass;
        this.serviceCallInterceptorGroupSupported = serviceCallInterceptorGroupSupported;
        this.serviceClassLoader = serviceClassLoader;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.serviceClassLoader);
            for (Method method : this.serviceClass.getMethods()) {
                Annotation[] methodAnnotations;
                for (Annotation annotation : methodAnnotations = method.getAnnotations()) {
                    this.checkForBeforeInterceptors(method, annotation);
                    this.checkForAfterInterceptors(method, annotation);
                    this.checkForAroundInterceptor(method, annotation);
                    this.checkForServiceExtraMethodAnnotation(method, annotation);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private boolean groupIsSupported(ServiceCallInterceptorGroup serviceCallInterceptorGroup) {
        if (ServiceCallInterceptorGroup.ALL.equals((Object)serviceCallInterceptorGroup)) {
            return true;
        }
        for (ServiceCallInterceptorGroup group : this.serviceCallInterceptorGroupSupported) {
            if (!serviceCallInterceptorGroup.equals((Object)group)) continue;
            return true;
        }
        return false;
    }

    private void checkForAroundInterceptor(Method method, Annotation annotation) {
        ServiceCallInterceptorGroup serviceCallInterceptorGroup;
        if (annotation instanceof ServiceCallAroundInterceptor && this.groupIsSupported(serviceCallInterceptorGroup = ((ServiceCallAroundInterceptor)annotation).group())) {
            Class interceptorClass = ((ServiceCallAroundInterceptor)annotation).value();
            try {
                ServiceMethodAroundAdvice aroundInterceptor = (ServiceMethodAroundAdvice)interceptorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.aroundInterceptors.put(method, aroundInterceptor);
            }
            catch (Exception e) {
                throw new RuleServiceRuntimeException(String.format("Failed to instante 'around' interceptor for method '%s' in class '%s'.", method.getName(), this.serviceClass.getName()), e);
            }
        }
    }

    private void checkForBeforeInterceptors(Method method, Annotation annotation) {
        ServiceCallInterceptorGroup serviceCallInterceptorGroup;
        if (annotation instanceof ServiceCallBeforeInterceptor && this.groupIsSupported(serviceCallInterceptorGroup = ((ServiceCallBeforeInterceptor)annotation).group())) {
            Class[] interceptorClasses = ((ServiceCallBeforeInterceptor)annotation).value();
            List<ServiceMethodBeforeAdvice> interceptors = this.beforeInterceptors.get(method);
            if (interceptors == null) {
                interceptors = new ArrayList<ServiceMethodBeforeAdvice>();
                this.beforeInterceptors.put(method, interceptors);
            }
            for (Class interceptorClass : interceptorClasses) {
                try {
                    ServiceMethodBeforeAdvice preInterceptor = (ServiceMethodBeforeAdvice)interceptorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    interceptors.add(preInterceptor);
                }
                catch (Exception e) {
                    throw new RuleServiceRuntimeException(String.format("Failed to instante 'before' interceptor for method '%s' in class '%s'.", method.getName(), this.serviceClass.getName()), e);
                }
            }
        }
        if (annotation instanceof ServiceCallBeforeInterceptors) {
            ServiceCallBeforeInterceptor[] serviceCallBeforeInterceptors;
            for (ServiceCallBeforeInterceptor serviceCallBeforeInterceptor : serviceCallBeforeInterceptors = ((ServiceCallBeforeInterceptors)annotation).value()) {
                this.checkForBeforeInterceptors(method, (Annotation)serviceCallBeforeInterceptor);
            }
        }
    }

    private void checkForServiceExtraMethodAnnotation(Method method, Annotation annotation) {
        if (annotation instanceof ServiceExtraMethod) {
            Class serviceExtraMethodHandlerClass = ((ServiceExtraMethod)annotation).value();
            try {
                ServiceExtraMethodHandler serviceMethodAdvice = (ServiceExtraMethodHandler)serviceExtraMethodHandlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.serviceExtraMethodAnnotations.put(method, serviceMethodAdvice);
            }
            catch (Exception e) {
                throw new RuleServiceRuntimeException(String.format("Failed to instante service method handler for method '%s' in class '%s'.", method.getName(), this.serviceClass.getName()), e);
            }
        }
    }

    private void checkForAfterInterceptors(Method method, Annotation annotation) {
        ServiceCallInterceptorGroup serviceCallInterceptorGroup;
        if (annotation instanceof ServiceCallAfterInterceptor && this.groupIsSupported(serviceCallInterceptorGroup = ((ServiceCallAfterInterceptor)annotation).group())) {
            Class[] interceptorClasses = ((ServiceCallAfterInterceptor)annotation).value();
            List<ServiceMethodAfterAdvice<?>> interceptors = this.afterInterceptors.get(method);
            if (interceptors == null) {
                interceptors = new ArrayList();
                this.afterInterceptors.put(method, interceptors);
            }
            for (Class interceptorClass : interceptorClasses) {
                try {
                    ServiceMethodAfterAdvice postInterceptor = (ServiceMethodAfterAdvice)interceptorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    interceptors.add(postInterceptor);
                }
                catch (Exception e) {
                    throw new RuleServiceRuntimeException(String.format("Failed to instante 'afterReturning' interceptor for method '%s' in class '%s'.", method.getName(), this.serviceClass.getName()), e);
                }
            }
        }
        if (annotation instanceof ServiceCallAfterInterceptors) {
            ServiceCallAfterInterceptor[] serviceCallAfterInterceptors;
            for (ServiceCallAfterInterceptor serviceCallAfterInterceptor : serviceCallAfterInterceptors = ((ServiceCallAfterInterceptors)annotation).value()) {
                this.checkForAfterInterceptors(method, (Annotation)serviceCallAfterInterceptor);
            }
        }
    }

    protected void beforeInvocation(Method interfaceMethod, Object ... args) throws Throwable {
        List<ServiceMethodBeforeAdvice> preInterceptors = this.beforeInterceptors.get(interfaceMethod);
        if (preInterceptors != null && !preInterceptors.isEmpty()) {
            for (ServiceMethodBeforeAdvice interceptor : preInterceptors) {
                interceptor.before(interfaceMethod, this.serviceBean, args);
            }
        }
    }

    protected Object serviceExtraMethodInvoke(Method interfaceMethod, Object serviceBean, Object ... args) throws Throwable {
        ServiceExtraMethodHandler<?> serviceExtraMethodHandler = this.serviceExtraMethodAnnotations.get(interfaceMethod);
        if (serviceExtraMethodHandler != null) {
            return serviceExtraMethodHandler.invoke(interfaceMethod, serviceBean, args);
        }
        throw new OpenLRuntimeException("Service method advice hasn't been found!");
    }

    protected Object afterInvocation(Method interfaceMethod, Object result, Exception t, Object ... args) throws Throwable {
        List<ServiceMethodAfterAdvice<?>> postInterceptors = this.afterInterceptors.get(interfaceMethod);
        if (postInterceptors != null && !postInterceptors.isEmpty()) {
            Object ret = result;
            Exception lastOccuredException = t;
            for (ServiceMethodAfterAdvice<?> interceptor : postInterceptors) {
                try {
                    ret = lastOccuredException == null ? interceptor.afterReturning(interfaceMethod, ret, args) : interceptor.afterThrowing(interfaceMethod, lastOccuredException, args);
                    lastOccuredException = null;
                }
                catch (Exception e) {
                    lastOccuredException = e;
                    ret = null;
                }
            }
            if (lastOccuredException != null) {
                throw lastOccuredException;
            }
            return ret;
        }
        if (t != null) {
            throw t;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method calledMethod = invocation.getMethod();
        Object[] args = invocation.getArguments();
        Method interfaceMethod = MethodUtils.getMatchingAccessibleMethod(this.serviceClass, (String)calledMethod.getName(), (Class[])calledMethod.getParameterTypes());
        Object result = null;
        try {
            Method beanMethod = null;
            if (!calledMethod.isAnnotationPresent(ServiceExtraMethod.class) && (beanMethod = MethodUtils.getMatchingAccessibleMethod(this.serviceBean.getClass(), (String)calledMethod.getName(), (Class[])calledMethod.getParameterTypes())) == null) {
                StringBuilder sb = new StringBuilder();
                boolean flag = true;
                for (Class<?> clazz : calledMethod.getParameterTypes()) {
                    if (flag) {
                        flag = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(clazz.getCanonicalName());
                }
                throw new OpenLRuntimeException("Called method hasn't been found in service bean. Please, check that excel file contains method with name '" + calledMethod.getName() + "' and arguments (" + sb.toString() + ").");
            }
            try {
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.serviceClassLoader);
                    this.beforeInvocation(interfaceMethod, args);
                    result = this.aroundInterceptors.containsKey(interfaceMethod) ? this.aroundInterceptors.get(interfaceMethod).around(interfaceMethod, beanMethod, this.serviceBean, args) : (beanMethod != null ? beanMethod.invoke(this.serviceBean, args) : this.serviceExtraMethodInvoke(interfaceMethod, this.serviceBean, args));
                    result = this.afterInvocation(interfaceMethod, result, null, args);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    Throwable t = this.extractInvocationTargetException(e);
                    if (t instanceof Exception) {
                        result = this.afterInvocation(interfaceMethod, null, (Exception)t, args);
                    }
                    throw t;
                }
                result = this.afterInvocation(interfaceMethod, null, e, args);
            }
            Object e = result;
            return e;
        }
        catch (Exception t) {
            Pair<ExceptionType, String> p = this.getExceptionDetailAndType(t);
            throw new RuleServiceWrapperException((String)p.getRight(), (ExceptionType)((Object)p.getLeft()), this.getExceptionMessage(calledMethod, t, args), t);
        }
        finally {
            if (this.serviceBean instanceof IEngineWrapper) {
                IEngineWrapper engine = (IEngineWrapper)this.serviceBean;
                engine.release();
            } else {
                this.log.warn("Service bean doesn't implement IEngineWrapper interface. Plese, don't use deprecated static wrapper classes. It can be cause of memory leaks!!!");
            }
        }
    }

    private Throwable extractInvocationTargetException(Throwable e) {
        Throwable t = e;
        while (t instanceof InvocationTargetException || t instanceof UndeclaredThrowableException) {
            Throwable t1;
            if (t instanceof InvocationTargetException) {
                t = t1 = ((InvocationTargetException)t).getTargetException();
            }
            if (!(t instanceof UndeclaredThrowableException)) continue;
            t = t1 = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
        }
        return t;
    }

    protected Pair<ExceptionType, String> getExceptionDetailAndType(Exception ex) {
        Throwable t = ex;
        ExceptionType type = ExceptionType.SYSTEM;
        String message = ex.getMessage();
        boolean f = true;
        while (f) {
            if ((t = this.extractInvocationTargetException(t)) instanceof OpenLUserRuntimeException) {
                type = ExceptionType.USER_ERROR;
                message = t.getMessage();
            } else if (t instanceof OutsideOfValidDomainException) {
                type = ExceptionType.VALIDATION;
                message = ((OutsideOfValidDomainException)t).getOriginalMessage();
            } else if (t instanceof OpenLRuntimeException) {
                type = ExceptionType.RULES_RUNTIME;
                message = ((OpenLRuntimeException)t).getOriginalMessage();
            } else if (t instanceof OpenLCompilationException || t instanceof RuleServiceOpenLCompilationException) {
                type = ExceptionType.COMPILATION;
                message = t.getMessage();
            }
            if (t.getCause() == null) {
                f = false;
                continue;
            }
            t = t.getCause();
        }
        return new ImmutablePair((Object)type, (Object)message);
    }

    protected String getExceptionMessage(Method method, Throwable ex, Object ... args) {
        StringBuilder argsTypes = new StringBuilder();
        boolean f = false;
        for (Class<?> clazz : method.getParameterTypes()) {
            if (f) {
                argsTypes.append(", ");
            } else {
                f = true;
            }
            argsTypes.append(clazz.getName());
        }
        StringBuilder argsValues = new StringBuilder();
        f = false;
        for (Object arg : args) {
            if (f) {
                argsValues.append(", ");
            } else {
                f = true;
            }
            if (arg == null) {
                argsValues.append("null");
                continue;
            }
            argsValues.append(arg.toString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("During OpenL rule execution exception was occurred. Method name is '".toUpperCase());
        sb.append(method.getName());
        sb.append("'. Arguments types are: ");
        sb.append(argsTypes.toString());
        sb.append(". Arguments values are: ");
        sb.append(argsValues.toString().replace("\r", "").replace("\n", ""));
        sb.append(". Exception class is: ");
        sb.append(ex.getClass().toString());
        sb.append(".");
        if (ex.getMessage() != null) {
            sb.append(" Exception message is: ");
            sb.append(ex.getMessage());
        }
        sb.append(" OpenL clause messages are: ");
        boolean isNotFirst = false;
        for (Throwable t = ex.getCause(); t != null && t.getCause() != t; t = t.getCause()) {
            if (!(t instanceof OpenLRuntimeException) && !(t instanceof OpenLException) || t.getMessage() == null) continue;
            if (isNotFirst) {
                sb.append(MSG_SEPARATOR);
            }
            isNotFirst = true;
            if (t instanceof OpenLRuntimeException) {
                sb.append(((OpenLRuntimeException)t).getOriginalMessage());
                continue;
            }
            sb.append(t.getMessage());
        }
        return sb.toString();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

