/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.loader;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.common.impl.CommonVersionImpl;
import org.openl.rules.project.abstraction.Deployment;
import org.openl.rules.repository.api.FileData;
import org.openl.rules.repository.api.FolderRepository;
import org.openl.rules.repository.api.Repository;
import org.openl.rules.ruleservice.loader.DataSource;
import org.openl.rules.ruleservice.loader.DataSourceListener;
import org.openl.util.RuntimeExceptionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductionRepositoryDataSource
implements DataSource {
    private final Logger log = LoggerFactory.getLogger(ProductionRepositoryDataSource.class);
    private Repository repository;
    private boolean includeVersionInDeploymentName = false;
    private String deployPath;

    @Override
    public Collection<Deployment> getDeployments() {
        List fileDatas;
        try {
            fileDatas = this.repository.supports().folders() ? ((FolderRepository)this.repository).listFolders(this.deployPath) : this.repository.list(this.deployPath);
        }
        catch (IOException ex) {
            throw RuntimeExceptionWrapper.wrap((Throwable)ex);
        }
        ConcurrentHashMap<String, Deployment> deployments = new ConcurrentHashMap<String, Deployment>();
        for (FileData fileData : fileDatas) {
            String deploymentFolderName;
            String deploymentName = deploymentFolderName = fileData.getName().substring(this.deployPath.length()).split("/")[0];
            CommonVersionImpl commonVersion = null;
            if (this.includeVersionInDeploymentName) {
                int separatorPosition = deploymentFolderName.lastIndexOf("#");
                if (separatorPosition >= 0) {
                    deploymentName = deploymentFolderName.substring(0, separatorPosition);
                    int version = Integer.parseInt(deploymentFolderName.substring(separatorPosition + 1));
                    commonVersion = new CommonVersionImpl(version);
                } else {
                    commonVersion = null;
                    this.log.error("WebServices are configured to include version in deployment name, but version isn't found in the name.");
                }
            } else {
                String version = fileData.getVersion();
                if (version != null) {
                    commonVersion = new CommonVersionImpl(version);
                }
            }
            String folderPath = this.deployPath + deploymentFolderName;
            boolean folderStructure = this.isFolderStructure(folderPath);
            Deployment deployment = new Deployment(this.repository, folderPath, deploymentName, (CommonVersion)commonVersion, folderStructure);
            deployments.putIfAbsent(deploymentFolderName, deployment);
        }
        return deployments.values();
    }

    @Override
    public Deployment getDeployment(String deploymentName, CommonVersion deploymentVersion) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("deploymentName argument must not be null.");
        }
        if (deploymentVersion == null) {
            throw new IllegalArgumentException("deploymentVersion argument must not be null.");
        }
        this.log.debug("Getting deployement with name='{}' and version='{}'", (Object)deploymentName, (Object)deploymentVersion.getVersionName());
        String name = this.includeVersionInDeploymentName ? deploymentName + "#" + deploymentVersion.getVersionName() : deploymentName;
        String folderPath = this.deployPath + name;
        boolean folderStructure = this.isFolderStructure(folderPath);
        return new Deployment(this.repository, folderPath, deploymentName, deploymentVersion, folderStructure);
    }

    @Override
    public void setListener(DataSourceListener dataSourceListener) {
        if (dataSourceListener == null) {
            this.repository.setListener(null);
        } else {
            this.repository.setListener(dataSourceListener::onDeploymentAdded);
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.log.debug("JCR data source releasing");
        if (this.repository instanceof Closeable) {
            ((Closeable)this.repository).close();
        }
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setIncludeVersionInDeploymentName(boolean includeVersionInDeploymentName) {
        this.includeVersionInDeploymentName = includeVersionInDeploymentName;
    }

    public void setDeployPath(String deployPath) {
        this.deployPath = deployPath.isEmpty() || deployPath.endsWith("/") ? deployPath : deployPath + "/";
    }

    private boolean isFolderStructure(String deploymentFolderPath) {
        boolean folderStructure;
        try {
            folderStructure = this.repository.supports().folders() ? !((FolderRepository)this.repository).listFolders(deploymentFolderPath + "/").isEmpty() : false;
        }
        catch (IOException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
        return folderStructure;
    }
}

