/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.loader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.openl.rules.ruleservice.core.RuleServiceRuntimeException;
import org.openl.rules.workspace.lw.impl.FolderHelper;
import org.openl.util.FileUtils;
import org.openl.util.ZipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;

public class UnpackClasspathJarToDirectoryBean
implements InitializingBean {
    private final Logger log = LoggerFactory.getLogger(UnpackClasspathJarToDirectoryBean.class);
    public static final String DEPLOYMENT_DESCRIPTOR_FILE_NAME = "deployment.xml";
    private String destinationDirectory;
    private boolean createDestinationDirectory = true;
    private boolean clearDestinationDirectory = true;
    private boolean unpackAllJarsInOneDeployment = true;
    private boolean supportDeploymentVersion = false;
    private boolean enabled = true;
    private String deploymentVersionSuffix = "_v0.0.1";

    public boolean isUnpackAllJarsInOneDeployment() {
        return this.unpackAllJarsInOneDeployment;
    }

    public void setUnpackAllJarsInOneDeployment(boolean unpackAllJarsInOneDeployment) {
        this.unpackAllJarsInOneDeployment = unpackAllJarsInOneDeployment;
    }

    public String getDeploymentVersionSuffix() {
        return this.deploymentVersionSuffix;
    }

    public void setDeploymentVersionSuffix(String deploymentVersionSuffix) {
        this.deploymentVersionSuffix = deploymentVersionSuffix;
    }

    public String getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public boolean isCreateDestinationDirectory() {
        return this.createDestinationDirectory;
    }

    public void setCreateDestinationDirectory(boolean createDestinationDirectory) {
        this.createDestinationDirectory = createDestinationDirectory;
    }

    public boolean isClearDestinationDirectory() {
        return this.clearDestinationDirectory;
    }

    public void setClearDestinationDirectory(boolean clearDestinationDirectory) {
        this.clearDestinationDirectory = clearDestinationDirectory;
    }

    public void setDestinationDirectory(String destinationDirectory) {
        if (destinationDirectory == null) {
            throw new IllegalArgumentException("destinationDirectory argument must not be null!");
        }
        this.destinationDirectory = destinationDirectory;
    }

    public boolean isSupportDeploymentVersion() {
        return this.supportDeploymentVersion;
    }

    public void setSupportDeploymentVersion(boolean supportDeploymentVersion) {
        this.supportDeploymentVersion = supportDeploymentVersion;
    }

    private static boolean checkOrCreateFolder(File location) {
        if (location.exists()) {
            return true;
        }
        return location.mkdirs();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractJarForJboss(URL resourceURL, File desFile, boolean isDeploymentJar) throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        URLConnection conn = resourceURL.openConnection();
        Object content = conn.getContent();
        String urlString = resourceURL.toString();
        Object jarFile = new URL(urlString = urlString.substring(0, urlString.lastIndexOf(".jar") + 4)).openConnection().getContent();
        Class<?> clazz = jarFile.getClass();
        if (!"org.jboss.vfs.VirtualFile".equals(clazz.getName())) throw new RuleServiceRuntimeException("Protocol VFS supports only for JBoss VFS. URL content must be org.jboss.vfs.VirtualFile!");
        Method getChildrenMethod = clazz.getMethod("getChildren", new Class[0]);
        List children = (List)getChildrenMethod.invoke(jarFile, new Object[0]);
        if (children.isEmpty()) throw new RuleServiceRuntimeException("Protocol VFS supports only for JBoss VFS. URL content must be org.jboss.vfs.VirtualFile!");
        Method getNameMethod = clazz.getMethod("getName", new Class[0]);
        String name = (String)getNameMethod.invoke(jarFile, new Object[0]);
        File d = desFile;
        if (!this.isUnpackAllJarsInOneDeployment()) {
            String folderName = FileUtils.getBaseName((String)name);
            if (this.isSupportDeploymentVersion()) {
                folderName = folderName + this.getDeploymentVersionSuffix();
            }
            d = new File(desFile, folderName);
            d.mkdirs();
        }
        File newProjectDir = null;
        if (!isDeploymentJar) {
            newProjectDir = new File(d, FileUtils.getBaseName((String)name));
            newProjectDir.mkdirs();
        } else {
            newProjectDir = d;
        }
        Class<?> VFSUtilsClazz = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.vfs.VFSUtils");
        Method recursiveCopyMethod = VFSUtilsClazz.getMethod("recursiveCopy", clazz, File.class);
        for (Object child : children) {
            recursiveCopyMethod.invoke(VFSUtilsClazz, child, newProjectDir);
        }
    }

    public void afterPropertiesSet() throws IOException {
        String folderName;
        Resource[] resources;
        if (!this.isEnabled()) {
            return;
        }
        String destDirectory = this.getDestinationDirectory();
        if (destDirectory == null) {
            throw new IllegalStateException("Distination directory is null. Please, check the bean configuration.");
        }
        File desFile = new File(destDirectory);
        if (!this.isCreateDestinationDirectory()) {
            if (!desFile.exists()) {
                throw new IOException("Destination folder doesn't exist. Path: " + destDirectory);
            }
            if (!desFile.isDirectory()) {
                throw new IOException("Destination path isn't a directory on the file system. Path: " + destDirectory);
            }
        } else if (UnpackClasspathJarToDirectoryBean.checkOrCreateFolder(desFile)) {
            this.log.info("Destination folder is already exist. Path: {}", (Object)destDirectory);
        } else {
            this.log.info("Destination folder has been created. Path: {}", (Object)destDirectory);
        }
        if (this.isClearDestinationDirectory() && !FolderHelper.clearFolder((File)new File(destDirectory))) {
            this.log.error("Failed to clean a folder. Path: '{}'", (Object)destDirectory);
        }
        PathMatchingResourcePatternResolver prpr = new PathMatchingResourcePatternResolver();
        for (Resource rulesXmlResource : resources = prpr.getResources("classpath*:rules.xml")) {
            File file;
            block25: {
                file = null;
                try {
                    URL resourceURL = rulesXmlResource.getURL();
                    if ("jar".equals(resourceURL.getProtocol()) || "wsjar".equals(resourceURL.getProtocol())) {
                        URL jarUrl = ResourceUtils.extractJarFileURL((URL)resourceURL);
                        file = ResourceUtils.getFile((URL)jarUrl);
                        break block25;
                    }
                    if ("vfs".equals(rulesXmlResource.getURL().getProtocol())) {
                        this.extractJarForJboss(resourceURL, desFile, false);
                        this.log.info("Unpacking '{}' into '{}' has been completed.", (Object)resourceURL, (Object)destDirectory);
                        continue;
                    }
                    throw new RuleServiceRuntimeException("Protocol for URL isn't supported! URL: " + resourceURL.toString());
                }
                catch (Exception e) {
                    this.log.error("Failed to load a resource!", (Throwable)e);
                    throw new IOException("Failed to load a resource!", e);
                }
            }
            if (!file.exists()) {
                throw new IOException("File hasn't been found. File: " + file.getAbsolutePath());
            }
            File d = desFile;
            if (!this.isUnpackAllJarsInOneDeployment()) {
                folderName = FileUtils.getBaseName((String)file.getCanonicalPath());
                if (this.isSupportDeploymentVersion()) {
                    folderName = folderName + this.getDeploymentVersionSuffix();
                }
                d = new File(desFile, folderName);
                this.recreateFolderIfExists(d);
            }
            File destDir = new File(d, FileUtils.getBaseName((String)file.getCanonicalPath()));
            this.recreateFolderIfExists(destDir);
            ZipUtils.extractAll((File)file, (File)destDir);
            this.log.info("Unpacking '{}' into '{}' was completed.", (Object)file.getAbsolutePath(), (Object)destDirectory);
        }
        Resource[] deploymentResources = prpr.getResources("classpath*:deployment.xml");
        if (!this.isUnpackAllJarsInOneDeployment()) {
            for (Resource deploymentResource : deploymentResources) {
                File file;
                block26: {
                    file = null;
                    try {
                        URL resourceURL = deploymentResource.getURL();
                        if ("jar".equals(resourceURL.getProtocol()) || "wsjar".equals(resourceURL.getProtocol())) {
                            URL jarUrl = ResourceUtils.extractJarFileURL((URL)resourceURL);
                            file = ResourceUtils.getFile((URL)jarUrl);
                            break block26;
                        }
                        if ("vfs".equals(deploymentResource.getURL().getProtocol())) {
                            this.extractJarForJboss(resourceURL, desFile, true);
                            this.log.info("Unpacking '{}' into '{}' has been completed.", (Object)resourceURL, (Object)destDirectory);
                            continue;
                        }
                        throw new RuleServiceRuntimeException("Protocol for URL isn't supported! URL: " + resourceURL.toString());
                    }
                    catch (Exception e) {
                        this.log.error("Failed to load a resource!", (Throwable)e);
                        throw new IOException("Failed to load a resource!", e);
                    }
                }
                if (!file.exists()) {
                    throw new IOException("File hasn't been found. File: " + file.getAbsolutePath());
                }
                folderName = FileUtils.getBaseName((String)file.getCanonicalPath());
                if (this.isSupportDeploymentVersion()) {
                    folderName = folderName + this.getDeploymentVersionSuffix();
                }
                File d = new File(desFile, folderName);
                this.recreateFolderIfExists(d);
                ZipUtils.extractAll((File)file, (File)d);
                this.log.info("Unpacking '{}' into '{}' has been completed.", (Object)file.getAbsolutePath(), (Object)destDirectory);
            }
        }
    }

    private void recreateFolderIfExists(File d) {
        if (!this.isClearDestinationDirectory() && d.exists() && !FolderHelper.deleteFolder((File)d)) {
            this.log.error("Failed to remove a folder. Path: '{}'", (Object)d.getAbsolutePath());
        }
        d.mkdirs();
    }
}

