/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.management;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openl.rules.ruleservice.conf.ServiceConfigurer;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleService;
import org.openl.rules.ruleservice.core.RuleServiceDeployException;
import org.openl.rules.ruleservice.core.RuleServiceUndeployException;
import org.openl.rules.ruleservice.core.ServiceDescription;
import org.openl.rules.ruleservice.loader.DataSourceListener;
import org.openl.rules.ruleservice.loader.RuleServiceLoader;
import org.openl.rules.ruleservice.management.ServiceDescriptionHolder;
import org.openl.rules.ruleservice.management.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManagerImpl
implements ServiceManager,
DataSourceListener {
    private final Logger log = LoggerFactory.getLogger(ServiceManagerImpl.class);
    private RuleService ruleService;
    private ServiceConfigurer serviceConfigurer;
    private RuleServiceLoader ruleServiceLoader;
    private Map<String, ServiceDescription> serviceDescriptions = new HashMap<String, ServiceDescription>();
    private Map<String, ServiceDescription> failedServiceDescriptions = new HashMap<String, ServiceDescription>();

    public void setRuleServiceLoader(RuleServiceLoader ruleServiceLoader) {
        if (this.ruleServiceLoader != null) {
            this.ruleServiceLoader.setListener(null);
        }
        this.ruleServiceLoader = ruleServiceLoader;
        if (this.ruleServiceLoader != null) {
            this.ruleServiceLoader.setListener(this);
        }
    }

    public RuleService getRuleService() {
        return this.ruleService;
    }

    public void setRuleService(RuleService ruleService) {
        if (ruleService == null) {
            throw new IllegalArgumentException("ruleService must not be null!");
        }
        this.ruleService = ruleService;
    }

    public ServiceConfigurer getServiceConfigurer() {
        return this.serviceConfigurer;
    }

    public void setServiceConfigurer(ServiceConfigurer serviceConfigurer) {
        if (serviceConfigurer == null) {
            throw new IllegalArgumentException("serviceConfigurer must not be null!");
        }
        this.serviceConfigurer = serviceConfigurer;
    }

    @Override
    public void start() {
        this.log.info("Assembling services after service manager start.");
        this.processServices();
    }

    @Override
    public void onDeploymentAdded() {
        this.log.info("Assembling services after data source modification.");
        this.processServices();
    }

    private synchronized void processServices() {
        Map<String, ServiceDescription> newServices = this.gatherServicesToBeDeployed();
        this.undeployUnnecessary(newServices);
        this.deployServices(newServices);
    }

    protected Map<String, ServiceDescription> gatherServicesToBeDeployed() {
        try {
            Collection<ServiceDescription> servicesToBeDeployed = this.serviceConfigurer.getServicesToBeDeployed(this.ruleServiceLoader);
            HashMap<String, ServiceDescription> services = new HashMap<String, ServiceDescription>();
            for (ServiceDescription serviceDescription : servicesToBeDeployed) {
                if (services.containsKey(serviceDescription.getName())) {
                    this.log.warn("Service '{}' is duplicated! Only one service with this the same name can be deployed! Please, check your configuration!", (Object)serviceDescription.getName());
                    continue;
                }
                services.put(serviceDescription.getName(), serviceDescription);
            }
            return services;
        }
        catch (Exception e) {
            this.log.error("Failed to gather services to be deployed.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeployUnnecessary(Map<String, ServiceDescription> newServices) {
        for (OpenLService openLService : this.ruleService.getServices()) {
            String runningServiceName = openLService.getName();
            if (newServices.containsKey(runningServiceName)) continue;
            try {
                ServiceDescription serviceDescription = this.serviceDescriptions.get(runningServiceName);
                ServiceDescriptionHolder.getInstance().setServiceDescription(serviceDescription);
                this.ruleService.undeploy(runningServiceName);
                this.serviceDescriptions.remove(runningServiceName);
                this.failedServiceDescriptions.remove(runningServiceName);
            }
            catch (RuleServiceUndeployException e) {
                this.log.error("Failed to undeploy '{}' service.", (Object)runningServiceName, (Object)e);
            }
            finally {
                ServiceDescriptionHolder.getInstance().remove();
            }
        }
    }

    private boolean isServiceDeployed(String serviceName) {
        return this.ruleService.getServiceByName(serviceName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployServices(Map<String, ServiceDescription> newServices) {
        for (ServiceDescription serviceDescription : newServices.values()) {
            String serviceName = serviceDescription.getName();
            try {
                ServiceDescriptionHolder.getInstance().setServiceDescription(serviceDescription);
                if (!this.isServiceDeployed(serviceName)) {
                    ServiceDescription failedServiceDescription = this.failedServiceDescriptions.get(serviceName);
                    if (failedServiceDescription != null) {
                        if (!serviceName.equals(failedServiceDescription.getName())) {
                            throw new IllegalStateException();
                        }
                        if (failedServiceDescription.getDeployment().getVersion().compareTo((Object)serviceDescription.getDeployment().getVersion()) == 0) continue;
                        this.failedServiceDescriptions.remove(serviceName);
                        this.ruleService.deploy(serviceDescription);
                        this.serviceDescriptions.put(serviceName, serviceDescription);
                        continue;
                    }
                    this.ruleService.deploy(serviceDescription);
                    this.serviceDescriptions.put(serviceName, serviceDescription);
                    continue;
                }
                this.ruleService.redeploy(serviceDescription);
                this.serviceDescriptions.put(serviceName, serviceDescription);
            }
            catch (RuleServiceDeployException e) {
                this.failedServiceDescriptions.put(serviceName, serviceDescription);
                this.log.error("Failed to deploy '{}' service.", (Object)serviceName, (Object)e);
            }
            catch (RuleServiceUndeployException e) {
                this.log.error("Failed to undeploy '{}' service.", (Object)serviceName, (Object)e);
            }
            finally {
                ServiceDescriptionHolder.getInstance().remove();
            }
        }
    }
}

