/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish;

import java.util.ArrayList;
import java.util.Collection;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceDeployException;
import org.openl.rules.ruleservice.core.RuleServiceUndeployException;
import org.openl.rules.ruleservice.publish.RuleServicePublisher;
import org.openl.rules.ruleservice.publish.RuleServicePublisherListener;
import org.openl.rules.ruleservice.publish.URLHelper;

public abstract class AbstractRuleServicePublisher
implements RuleServicePublisher {
    protected Collection<RuleServicePublisherListener> listeners = new ArrayList<RuleServicePublisherListener>();
    private RulesDeploy.PublisherType publisherType;

    public void setPublisherType(RulesDeploy.PublisherType publisherType) {
        this.publisherType = publisherType;
    }

    public RulesDeploy.PublisherType getPublisherType() {
        return this.publisherType;
    }

    protected void fireDeployListeners(OpenLService service) {
        for (RuleServicePublisherListener listener : this.listeners) {
            listener.onDeploy(service);
        }
    }

    protected void fireUndeployListeners(String serviceName) {
        for (RuleServicePublisherListener listener : this.listeners) {
            listener.onUndeploy(serviceName);
        }
    }

    protected String processURL(String url) {
        String ret = url;
        while (ret.charAt(0) == '/') {
            ret = ret.substring(1);
        }
        return URLHelper.processURL(ret);
    }

    public void setListeners(Collection<RuleServicePublisherListener> listeners) {
        this.listeners = listeners;
    }

    public Collection<RuleServicePublisherListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void addListener(RuleServicePublisherListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public void removeListener(RuleServicePublisherListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected abstract void deployService(OpenLService var1) throws RuleServiceDeployException;

    @Override
    public final void deploy(OpenLService service) throws RuleServiceDeployException {
        this.deployService(service);
        this.fireDeployListeners(service);
    }

    protected abstract void undeployService(String var1) throws RuleServiceUndeployException;

    @Override
    public final void undeploy(String serviceName) throws RuleServiceUndeployException {
        this.undeployService(serviceName);
        this.fireUndeployListeners(serviceName);
    }
}

