/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.lazy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerAdapter;
import org.openl.CompiledOpenClass;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.publish.lazy.Event;
import org.openl.rules.ruleservice.publish.lazy.Key;
import org.openl.rules.ruleservice.publish.lazy.OpenLEhCacheHolder;

public final class CompiledOpenClassCache {
    private Map<Key, Collection<Event>> eventsMap = new HashMap<Key, Collection<Event>>();

    private CompiledOpenClassCache() {
        OpenLEhCacheHolder.getInstance().getModulesCache().getCacheEventNotificationService().registerListener((CacheEventListener)new CacheEventListenerAdapter(){

            public void notifyElementEvicted(Ehcache cache, Element element) {
                this.process(element.getObjectKey());
            }

            public void notifyElementExpired(Ehcache cache, Element element) {
                this.process(element.getObjectKey());
            }

            public void notifyElementRemoved(Ehcache cache, Element element) {
                this.process(element.getObjectKey());
            }

            public void notifyElementPut(Ehcache cache, Element element) {
                this.process(element.getObjectKey());
            }

            public void notifyElementUpdated(Ehcache cache, Element element) {
                this.process(element.getObjectKey());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void process(Object key) {
                Map map = CompiledOpenClassCache.this.eventsMap;
                synchronized (map) {
                    Collection events = (Collection)CompiledOpenClassCache.this.eventsMap.get(key);
                    if (events != null) {
                        for (Event e : events) {
                            e.onEvent();
                        }
                    }
                }
            }
        });
    }

    public static CompiledOpenClassCache getInstance() {
        return CompiledOpenClassHolder.INSTANCE;
    }

    public CompiledOpenClass get(DeploymentDescription deploymentDescription, String dependencyName) {
        Objects.requireNonNull(deploymentDescription, "deploymentDescription must not be null!");
        Objects.requireNonNull(dependencyName, "dependencyName must not be null!");
        Key key = new Key(deploymentDescription, dependencyName);
        Cache cache = OpenLEhCacheHolder.getInstance().getModulesCache();
        Element element = cache.get((Object)key);
        if (element == null) {
            return null;
        }
        return (CompiledOpenClass)element.getObjectValue();
    }

    public void putToCache(DeploymentDescription deploymentDescription, String dependencyName, CompiledOpenClass compiledOpenClass) {
        Objects.requireNonNull(deploymentDescription, "deploymentDescription must not be null!");
        Objects.requireNonNull(dependencyName, "dependencyName must not be null!");
        Key key = new Key(deploymentDescription, dependencyName);
        Element newElement = new Element((Object)key, (Object)compiledOpenClass);
        Cache cache = OpenLEhCacheHolder.getInstance().getModulesCache();
        cache.put(newElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEvent(DeploymentDescription deploymentDescription, String dependencyName, Event event) {
        Objects.requireNonNull(deploymentDescription, "deploymentDescription must not be null!");
        Objects.requireNonNull(dependencyName, "dependencyName must not be null!");
        Key key = new Key(deploymentDescription, dependencyName);
        Map<Key, Collection<Event>> map = this.eventsMap;
        synchronized (map) {
            Collection events = this.eventsMap.computeIfAbsent(key, e -> new ArrayList());
            events.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(DeploymentDescription deploymentDescription) {
        if (deploymentDescription == null) {
            throw new IllegalArgumentException("deploymentDescription must not be null!");
        }
        Cache cache = OpenLEhCacheHolder.getInstance().getModulesCache();
        for (Key key : cache.getKeys()) {
            DeploymentDescription deployment = key.getDeploymentDescription();
            if (!deploymentDescription.getName().equals(deployment.getName()) || !deploymentDescription.getVersion().equals(deployment.getVersion())) continue;
            cache.remove((Object)key);
        }
        Map<Key, Collection<Event>> map = this.eventsMap;
        synchronized (map) {
            Iterator<Map.Entry<Key, Collection<Event>>> eventsMapIterator = this.eventsMap.entrySet().iterator();
            while (eventsMapIterator.hasNext()) {
                Map.Entry<Key, Collection<Event>> entry = eventsMapIterator.next();
                if (!deploymentDescription.getName().equals(entry.getKey().getDeploymentDescription().getName()) || !deploymentDescription.getVersion().equals(entry.getKey().getDeploymentDescription().getVersion())) continue;
                eventsMapIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Cache cache = OpenLEhCacheHolder.getInstance().getModulesCache();
        cache.removeAll();
        Map<Key, Collection<Event>> map = this.eventsMap;
        synchronized (map) {
            this.eventsMap.clear();
        }
    }

    private static class CompiledOpenClassHolder {
        public static final CompiledOpenClassCache INSTANCE = new CompiledOpenClassCache();

        private CompiledOpenClassHolder() {
        }
    }
}

