/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.lazy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.openl.classloader.SimpleBundleClassLoader;
import org.openl.dependency.IDependencyManager;
import org.openl.rules.project.instantiation.MultiModuleInstantiationStartegy;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.model.MethodFilter;
import org.openl.rules.project.model.Module;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.publish.lazy.LazyEngineFactory;
import org.openl.rules.runtime.InterfaceClassGenerator;
import org.openl.rules.runtime.InterfaceClassGeneratorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyInstantiationStrategy
extends MultiModuleInstantiationStartegy {
    private final Logger log = LoggerFactory.getLogger(LazyInstantiationStrategy.class);
    private LazyEngineFactory<?> engineFactory;
    private DeploymentDescription deployment;
    private ClassLoader classLoader = null;

    public DeploymentDescription getDeployment() {
        return this.deployment;
    }

    public LazyInstantiationStrategy(DeploymentDescription deployment, final Module module, IDependencyManager dependencyManager) {
        super((Collection)new ArrayList<Module>(){
            private static final long serialVersionUID = 1L;
            {
                this.add(module);
            }
        }, dependencyManager, true);
        Objects.requireNonNull(deployment, "deployment must not be null!");
        this.deployment = deployment;
    }

    public LazyInstantiationStrategy(DeploymentDescription deployment, Collection<Module> modules, IDependencyManager dependencyManager) {
        super(modules, dependencyManager, true);
        Objects.requireNonNull(deployment, "deployment must not be null!");
        this.deployment = deployment;
    }

    public LazyInstantiationStrategy(DeploymentDescription deployment, Collection<Module> modules, IDependencyManager dependencyManager, ClassLoader classLoader) {
        super(modules, dependencyManager, classLoader, true);
        Objects.requireNonNull(deployment, "deployment must not be null!");
        this.deployment = deployment;
    }

    public void reset() {
        super.reset();
        this.engineFactory = null;
    }

    protected ClassLoader initClassLoader() throws RulesInstantiationException {
        if (this.classLoader == null) {
            SimpleBundleClassLoader simpleBundleClassLoader = new SimpleBundleClassLoader(Thread.currentThread().getContextClassLoader());
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)simpleBundleClassLoader);
                this.classLoader = this.getEngineFactory().getCompiledOpenClass().getClassLoader();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        return this.classLoader;
    }

    public Class<?> getGeneratedRulesClass() throws RulesInstantiationException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            Class<?> clazz = this.getEngineFactory().getInterfaceClass();
            return clazz;
        }
        catch (Exception e) {
            throw new RulesInstantiationException("Failed to resolve interface", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instantiate(Class<?> rulesClass) throws RulesInstantiationException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            Object object = this.getEngineFactory().newInstance();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected LazyEngineFactory<?> getEngineFactory() {
        Class serviceClass = null;
        try {
            serviceClass = this.getServiceClass();
        }
        catch (ClassNotFoundException e) {
            this.log.debug("Failed to load service class.", (Throwable)e);
            serviceClass = null;
        }
        if (this.engineFactory == null || serviceClass != null && !this.engineFactory.getInterfaceClass().equals(serviceClass)) {
            this.engineFactory = new LazyEngineFactory(this.getDeployment(), this.getModules(), this.getDependencyManager(), serviceClass, this.getExternalParameters());
            HashSet allIncludes = new HashSet();
            HashSet allExcludes = new HashSet();
            for (Module m : this.getModules()) {
                MethodFilter methodFilter = m.getMethodFilter();
                if (methodFilter == null) continue;
                allIncludes.addAll(methodFilter.getIncludes());
                allExcludes.addAll(methodFilter.getExcludes());
            }
            if (!allIncludes.isEmpty() || !allExcludes.isEmpty()) {
                String[] includes = new String[]{};
                String[] excludes = new String[]{};
                includes = allIncludes.toArray(includes);
                excludes = allExcludes.toArray(excludes);
                this.engineFactory.setInterfaceClassGenerator((InterfaceClassGenerator)new InterfaceClassGeneratorImpl(includes, excludes));
            }
        }
        return this.engineFactory;
    }
}

